/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___NET_H___
#define ___NET_H___

typedef struct xlprox_v4 {
	unsigned int		v4;
	int			id;
} XLPROX_V4;

typedef struct xlprox_v6 {
	unsigned int		v6[4];
	int			id;
} XLPROX_V6;

typedef struct host_addr {
	short			type;
#define HAT_NONE	0
#define HAT_V4		4
#define HAT_V6		6

#define HAT_XLPROX_V4		104
#define HAT_XLPROX_V6		106

	short			size;
	int			port;
	union {
		char *			domain;
		unsigned int		v4;
		unsigned int		v6[4];
		XLPROX_V4		xp_v4;
		XLPROX_V6		xp_v6;
	} d;
} HOST_ADDR;



typedef struct net_packet {
	HOST_ADDR *	src_addr;
	HOST_ADDR *	dest_addr;
	int		size;
	void *		data;
} NET_PACKET;


#endif

