/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include "xl.h"
#include "gbview.h"
#include "xlerror.h"
#include "win_flame.h"

XL_SEXP * xl_gv_flame_rotate();

void
init_gv_flame_rotate(XLISP_ENV * env)
{
	set_env(env, l_string(std_cm,"gv-flame-rotate"),
			get_func_prim(xl_gv_flame_rotate,FO_APPLICATIVE,0,5,5));
}

XL_SEXP *
xl_gv_flame_rotate(
		XLISP_ENV * e,
		XL_SEXP * s,
		XLISP_ENV * a,
		XL_SYM_FIELD * sf)
{
XL_SEXP * from_x, * from_y, * to_x, * to_y;
GB_POINT from, to;
GBVIEW_FLAME * gf;

	gf = get_gf_from_sf(sf);

	from_x = get_el(s,1);
	from_y = get_el(s,2);
	to_x = get_el(s,3);
	to_y = get_el(s,4);
	if ( get_type(from_x) != XLT_FLOAT || get_type(from_y) != XLT_FLOAT
			|| get_type(to_x) != XLT_FLOAT || get_type(to_y) != XLT_FLOAT )
		goto type_missmatch;

	from.x = from_x->floating.data;
	from.y = from_y->floating.data;
	to.x = to_x->floating.data;
	to.y = to_y->floating.data;
	return get_integer(wf_rotate(gf,from, to),0);


type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"gv-flame-rotate"),
		List(n_get_string("type missmatch"),
			-1));
}
