/**********************************************************************
 
	Copyright (C) 2008- Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"memory_debug.h"
#include	"xl.h"
#include	"xlerror.h"
#include	"utils.h"
#include	"spidering.h"

XL_SEXP * gb_SPpermitAgent();

void
init_gb_SPpermitAgent(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"SPpermitAgent"),
		get_func_prim(gb_SPpermitAgent,FO_APPLICATIVE,0,3,4));
}

XL_SEXP *
gb_SPpermitAgent(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,
	XL_SYM_FIELD * sf)
{
XL_SEXP * path,* agent,*_info;
char * err;
int err_int;
void * info;
L_CHAR * ext;
int len;
	path = get_el(s,1);
	err = "path";
	err_int = 0;
	if ( get_type(path) != XLT_STRING )
		goto type_missmatch;
	agent = get_el(s,2);
	len = l_strlen(agent->string.data);
	ext = d_alloc(sizeof(L_CHAR)*(len+3));
	ext[0] = LC_SECC_HEADER;
	ext[1] = LC_SECC_AGENT;
	l_strcpy(&ext[2],agent->string.data);
	info = start_sp_operation_auth(&err_int,wa_list,path->string.data,ext,1);
	if ( info ) {
		err = "exist";
		d_f_ree(info);
		d_f_ree(ext);
		goto already_exist;
	}
	if ( list_length(s) == 4 ) {
		_info = get_el(s,3);
		err = "info";
		if ( get_type(_info) != XLT_RAW )
			goto type_missmatch;
		info = _info->raw.data;
	}
	else {
		info = 0;
	}
	if ( finish_sp_operation_auth(wa_list,path->string.data,ext,info) < 0 ) {
		d_f_ree(ext);
		goto already_exist;
	}
	d_f_ree(ext);
	return 0;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"SPpermitAgent"),
		List(n_get_string("type missmatch"),n_get_string(err),-1));
already_exist:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_DUP_DEFINITION,
		l_string(std_cm,"SPpermitAgent"),
		List(n_get_string("already exist agent"),
			get_integer(err_int,0),
			-1));
}

