/**********************************************************************
 
	Copyright (C) 2008 Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"win_flame.h"


#include	"machine/u_math.h"
#include	"win_flame.h"
#include	"memory_debug.h"
#include	"gbgraph.h"



#define PRI_OFFSET_RATE		20


void
e1ds_get_weight(GBVIEW_FLAME * gf,WIN_FLAME * wf)
{
float weight;
int measure;
int base_measure;
GV_RESOURCE_LIST * rl;
	if ( wf->flags & WFF_LUSTER )
		weight = W_E1D_LUSTER;
	else if ( wf->flags & WFF_POLY )
		weight = W_E1D_POLY;
	else	weight = W_E1D_PLOT;
	measure = (wf->small_rct.br.y - wf->small_rct.tl.y) *
		(wf->small_rct.br.x - wf->small_rct.tl.x);
	base_measure = gf->win_width * gf->win_height;
	rl = search_resource_list(gf,wf->draw,0,1);
	if ( rl == 0 )
		return;
	if ( measure > base_measure )
		rl->weight = weight;
	else	rl->weight = weight * measure/base_measure;
}



void
e1ds_copy_pixels(
	GBVIEW_FLAME * gf,
	WIN_FLAME * wf,unsigned long * buf,REAL1 * reso,GB_RECT * r)
{
int x,y,i,index;
int bf_i;
unsigned long * dest;
int f;
int width;
int y_index;
int y_index_gf;
int r_width;

	if ( wf->mov_flag )
		return;
	r->tl.y += wf->mov_y;
	r->tl.x += wf->mov_x;
	r->br.y += wf->mov_y;
	r->br.x += wf->mov_x;
	r_width = r->br.x - r->tl.x;
	insert_redraw_gbr(gf,r);
	f = 0;
	bf_i = 0;
	width = wf->small_rct.br.x - wf->small_rct.tl.x;
	for ( y = r->tl.y ; y < r->br.y ; y ++ ){
		if ( y < wf->small_rct.tl.y || y >= wf->small_rct.br.y ) {
			bf_i += r_width;
			continue;
		}
		y_index = (y - wf->small_rct.tl.y)*width;
		y_index_gf = y*gf->win_width;
		i = 0;
		for ( x = r->tl.x ; x < r->br.x ; x ++ ) {
			if ( x < wf->small_rct.tl.x || x >= wf->small_rct.br.x ) {
				i ++;
				bf_i ++;
				continue;
			}
			if ( reso[i] < 0 ) {
				i ++;
				bf_i ++;
				continue;
			}
			index = (x - wf->small_rct.tl.x) + y_index;
			dest = &wf->pixels[index];
			*dest = buf[bf_i]|(*dest&C_DIRTY);
			gf->redraw[x + y_index_gf] |= RP_REDRAW;
			i ++;
			f = 1;
		}
	}
	if ( f ) {
//		_wf_set_delay_redraw(gf);
		new_tick((void(*)(int))_wf_set_redraw,0,(int)gf);
	}
}



int
e1ds_redraw_rect(
	GBVIEW_FLAME * gf,
	WIN_FLAME * wf,GB_RECT *r,int * pri_cnt)
{
int min_x,max_x;
int min_y,max_y;
int xx,yy,i;
unsigned long * buf;
GB_POINT * pt_list;
REAL1 * pt_reso;
int w,h;
MAP_HISTORY * mh;
WIN_FLAME * _wf;
SURP_SET surp;
int id;
int ci_ret;
int width;
int yy_index;
unsigned long * target;
GB_RECT _r;
WF_PARAM_1D * p1d;

	ci_ret = 0;
	if ( r->tl.x < wf->small_rct.tl.x ) {
		if ( r->br.x <= wf->small_rct.tl.x )
			return -1;
		r->tl.x = wf->small_rct.tl.x;
	}
	if ( r->tl.x >= wf->small_rct.br.x )
		return -1;
	if ( r->br.x <= wf->small_rct.tl.x )
		return -1;
	if ( r->br.x > wf->small_rct.br.x ) {
		if ( r->tl.x >= wf->small_rct.br.x )
			return -1;
		r->br.x = wf->small_rct.br.x;
	}
	if ( r->tl.y < wf->small_rct.tl.y ) {
		if ( r->br.y <= wf->small_rct.tl.y )
			return -1;
		r->tl.y = wf->small_rct.tl.y;
	}
	if ( r->tl.y >= wf->small_rct.br.y )
		return -1;
	if ( r->br.y <= wf->small_rct.tl.y )
		return -1;
	if ( r->br.y > wf->small_rct.br.y ) {
		if ( r->tl.y >= wf->small_rct.br.y )
			return -1;
		r->br.y = wf->small_rct.br.y;
	}
	if ( r->tl.x < 0 ) {
		if ( r->br.x <= 0 )
			return -1;
		r->tl.x = 0;
	}
	if ( r->tl.x >= gf->win_width )
		return -1;
	if ( r->br.x <= 0 )
		return -1;
	if ( r->br.x > gf->win_width ) {
		if ( r->tl.x >= gf->win_width )
			return -1;
		r->br.x = gf->win_width;
	}
	if ( r->tl.y < 0 ) {
		if ( r->br.y <= 0 )
			return -1;
		r->tl.y = 0;
	}
	if ( r->tl.y >= gf->win_height )
		return -1;
	if ( r->br.y <= 0 )
		return -1;
	if ( r->br.y > gf->win_height ) {
		if ( r->tl.y >= gf->win_height )
			return -1;
		r->br.y = gf->win_height;
	}
	min_x = r->br.x;
	min_y = r->br.y;
	max_x = r->tl.x;
	max_y = r->tl.y;


	wf_lock(gf);


	if ( wf->flags & WFF_RESIZE ) {
		wf_unlock(gf);
		return -2;
	}
	width = wf->small_rct.br.x - wf->small_rct.tl.x;
	for ( yy = r->tl.y ; yy < r->br.y ; yy ++ ) {
		yy_index = (yy - wf->small_rct.tl.y) * width;
		for ( xx = r->tl.x ; xx < r->br.x ; xx ++ ){
			if ( !(wf->pixels[yy_index + xx - wf->small_rct.tl.x]&C_DIRTY) )
				continue;
			if ( min_x > xx )
				min_x = xx;
			if ( min_y > yy )
				min_y = yy;
			if ( max_x < xx+1 )
				max_x = xx+1;
			if ( max_y < yy+1 )
				max_y = yy+1;
		}
	}
	if ( max_x < min_x ) {
		wf_unlock(gf);
		return -1;
	}
	r->tl.x = min_x;
	r->tl.y = min_y;
	r->br.x = max_x;
	r->br.y = max_y;
	wf->mov_x = 0;
	wf->mov_y = 0;
	wf->mov_flag = 0;

	w = r->br.x - r->tl.x;
	h = r->br.y - r->tl.y;
	pt_list = d_alloc(w*sizeof(GB_POINT));
	pt_reso = d_alloc(w*sizeof(REAL1));
	buf = d_alloc(w*h*sizeof(long));
	i = 0;



	for ( xx = r->tl.x ; xx < r->br.x ; xx ++ ) {
		pt_list[i].x = xx;
		pt_list[i].y = 0;
		pt_reso[i] = gf->flame_base_resolution;
		i ++;	
	}
	for ( i = 0 ; i < w*h ; i ++ )
		buf[i] = C_TRANSPARENT;
	for ( yy = r->tl.y ; yy < r->br.y ; yy ++ ) {
		yy_index = (yy - wf->small_rct.tl.y) * width;
		for ( xx = r->tl.x ; xx < r->br.x ; xx ++ ) {
			target = &wf->pixels[yy_index + xx - wf->small_rct.tl.x];
			(*target) &= ~C_DIRTY;
		}
	}
	mh = add_mh(&gf->flame_base_display_map,wf->mh);


	if ( wf->flags & WFF_LUSTER )
		map_from_flame(mh,pt_list,pt_reso,w);

	_r = *r;
	_r.tl.y = _r.br.y = 0;
	set_surp(&surp,&_r,gf->flame_base_resolution);
	map_from_flame(mh,surp.ptr,surp.reso,SURP_NOS);
	id = wf->id;
	p1d = wf_get_param_1d(gf,wf);
	wf_unlock(gf);


	ci_ret = cache_image(
		gf,
		wf->id,wf->draw,pt_list,pt_reso,buf,
		w,r,mh,&surp,1,
		WFF_PLOT_DIRTY|WFF_LUSTER_DIRTY,
		p1d);

	wf_lock(gf);
	wf_free_param_1d(p1d);
	_wf = _get_wf_ptr(gf,id);
	if ( _wf != wf )
		goto end;
	if ( wf->flags & (WFF_FREE|WFF_FREE_OUTLIST) )
{ss_printf("FREE=RETURN-1\n");
		goto end;
}

	if ( !(ci_ret & WFF_DRAW) )
		(*pri_cnt) ++;

	if ( wf->flags & WFF_RESIZE ) {
		d_f_ree(buf);
		d_f_ree(pt_list);
		d_f_ree(pt_reso);
		free_mh(mh);
		wf_unlock(gf);
		return -2;
	}
	e1ds_copy_pixels(gf,wf,buf,pt_reso,r);

	if ( wf->mov_flag )
		wf_free_si(wf);
	else	regulate_si(wf);

end:
	wf_unlock(gf);
	d_f_ree(buf);
	d_f_ree(pt_list);
	d_f_ree(pt_reso);
	free_mh(mh);
	wf_set_delay_redraw_exec(gf);
	if ( ci_ret & WFF_FLUSH )
		return -4;
	return 0;
}



extern int spiral_count;

typedef struct redraw_pixel {
	int		w;
	int		h;
	int		st_w;
	int		st_h;
	int		rdm;
	int		delta[4];
} REDRAW_PIXEL;

void set_redraw_pixel(REDRAW_PIXEL*rp,GBVIEW_FLAME * gf);

void
e1ds_set_redraw_pixel(REDRAW_PIXEL*rp,GBVIEW_FLAME * gf)
{
double unit;
	unit = sqrt(((double)DL_PITCH)*DL_PITCH/
		    (gf->win_width*gf->win_height));
	rp->w = unit*gf->win_width;
	rp->h = unit*gf->win_height;
	rp->st_w = gf->win_width/2 - rp->w/2;
	rp->st_h = gf->win_height/2 - rp->h/2;
	
}

int
e1ds_inc_xy(int * x,int * y)
{
	if ( (*x) == 0 && (*y) == 0 )
		goto home;
	if ( (*y) < 0 && -(*y) >= (*x) && (*x) > (*y) ) {
		(*x) --;
		return 0;
	}
	if ( (*x) < 0 && (*x) <= (*y) && (*y) < -(*x) ) {
		(*y) ++;
		return 0;
	}
	if ( (*y) > 0 && -(*y) <= (*x) && (*x) < (*y) ) {
		(*x) ++;
		return 0;
	}
	/* if ( x > 0 && -x >= y && y > x ) */
	(*y) --;
	if ( (*x) == -(*y) )
		goto home;
	return 0;
home:
	(*x) ++;
	(*y) --;
	return 1;
}

int
_e1ds_redraw(GBVIEW_FLAME * gf,WIN_FLAME * wf)
{
int xx,yy;
GB_RECT rr;
int t,l,r,b;
int ret;
int sc;
int pri_cnt;
REDRAW_PIXEL rp;
int flush_flag = 0;

restart:
	flush_flag = 0;
	wf_lock(gf);
	sc = 0;
	wf->flags &= ~WFF_RESIZE;
	e1ds_set_redraw_pixel(&rp,gf);
	wf_unlock(gf);
	xx = yy = 0;
	t = l = r = b = 0;
	ret = 0;
	pri_cnt = 0;
	for ( ; ; ) {
		if ( rp.st_h + yy*rp.h < 0 )
			t = 1;
		if ( rp.st_h + yy*rp.h >= gf->win_height )
			b = 1;
		if ( rp.st_w + xx*rp.w < 0 )
			l = 1;
		if ( rp.st_w + xx*rp.w >= gf->win_width )
			r = 1;
		rr.tl.x = rp.st_w + xx*rp.w;
		rr.tl.y = rp.st_h + yy*rp.h;
		rr.br.x = rr.tl.x + rp.w;
		rr.br.y = rr.tl.y + rp.h;
/*
ss_printf("** %i(%x) ** xx %i %i %i %i %i %i\n",get_tid(),wf->flags,
xx,yy,t,b,l,r);
*/


		switch ( e1ds_redraw_rect(gf,wf,&rr,&pri_cnt) ) {
		case 0:
			ret = 1;
		case -1:
			break;
		case -2:
			goto restart;
		case -3:
			ret = 2;
			goto end;
		case -4:
			flush_flag = 1;
			break;
		default:
			er_panic("aaa");
		}
		if ( wf->flags & WFF_FREE ) {
			ret = 0;
			goto end;
		}
		if ( e1ds_inc_xy(&xx,&yy) ) {
			if ( t && b && l && r )
				break;
		}
		sc ++;
	}
end:
	if ( sc )
		_set_pri_adj(gf,wf,pri_cnt*PRI_OFFSET_RATE/sc);
	else	_set_pri_adj(gf,wf,pri_cnt);

	if ( flush_flag ) {
	GB_RECT rct;
		wf_work_area_flush(wf->wa_set);
		rct.tl.x = 0;
		rct.br.x = gf->win_width;
		rct.tl.y = gf->flame_base_y_offset + wf->e1d_y_top + wf->e1d_top_mergin;
		rct.br.y = gf->flame_base_y_offset + wf->e1d_y_bottom + wf->e1d_bottom_mergin;
		win_flame_dirty(gf,wf->id,&rct,WFF_LUSTER_DIRTY,0);

		goto restart;
	}

	return ret;
}

int
e1ds_redraw(GBVIEW_FLAME * gf,WIN_FLAME * wf)
{
int ret;
int flags;
int top,bottom;
	ret = 0;

	wf_lock(gf);
	top = gf->flame_base_y_offset + wf->e1d_y_top + wf->e1d_top_mergin;
	bottom = gf->flame_base_y_offset + wf->e1d_y_bottom + wf->e1d_bottom_mergin;
	if ( top >= gf->win_height ) {
		wf_unlock(gf);
		return 0;
	}
	if ( bottom <= 0 ) {
		wf_unlock(gf);
		return 0;
	}
	set_weight(gf,wf);
	flags = wf->flags;
	if ( wf->flags & (WFF_POLY_DIRTY|WFF_LUSTER_DIRTY) ) {
		wf->flags &= ~(WFF_POLY_DIRTY|WFF_LUSTER_DIRTY);
		wf_unlock(gf);
		if ( _e1ds_redraw(gf,wf) == 2 ) {
			ret = 2;
			wf->flags |= flags &
				(WFF_POLY_DIRTY|WFF_LUSTER_DIRTY);
		}
		else	ret = 1;
	}
	else	wf_unlock(gf);
	wf_lock(gf);
	if ( wf->flags & WFF_PLOT_DIRTY ) {
		wf->flags &= ~(WFF_PLOT_DIRTY|WFF_RESIZE);
		wf_unlock(gf);
		if ( _e1d_p_redraw(gf,wf) == 2 ) {
			ret = 2;
			wf->flags |= flags &
				(WFF_PLOT_DIRTY|WFF_RESIZE);
		}
		else	ret = 1;
	}
	else	wf_unlock(gf);
	return ret;
}

int
e1ds_zoom(GBVIEW_FLAME * gf,WIN_FLAME * wf,int w,int h,int * ix_x,int * ix_y)
{
unsigned long * target;
I_RECT new_rct;
int * ptr;
int x,y;
int xx,yy;
int ix;
int * ptr_x;
unsigned long * t_ptr;
int width,height;
int top,bottom;
	top = gf->flame_base_y_offset + wf->e1d_y_top + wf->e1d_top_mergin;
	bottom = gf->flame_base_y_offset + wf->e1d_y_bottom + wf->e1d_bottom_mergin;
	if ( top >= gf->win_height )
		return 0;
	if ( bottom <= 0 )
		return 0;

	wf_free_si(wf);

	new_rct.tl.x = new_rct.tl.y = 0;
	new_rct.br.x = new_rct.br.y = -1;
	
	ptr = ix_x;
	for ( x = 0 ; x < gf->win_width ; x ++ , ptr ++ ) {
		ix = *ptr;
		if ( ix < 0 )
			continue;
		if ( ix < wf->small_rct.tl.x )
			continue;
		if ( ix >= wf->small_rct.br.x )
			continue;
		if ( new_rct.tl.x > new_rct.br.x ) {
			new_rct.tl.x = x;
			new_rct.br.x = x+1;
		}
		else if ( x < new_rct.tl.x )
			new_rct.tl.x = x;
		else if ( x >= new_rct.br.x )
			new_rct.br.x = x+1;
	}
	new_rct.tl.y = wf->small_rct.tl.y;
	new_rct.br.y = wf->small_rct.br.y;
	
	if ( new_rct.tl.x > new_rct.br.x || new_rct.tl.y > new_rct.br.y )
		goto end;
	
	width = (wf->small_rct.br.x - wf->small_rct.tl.x);
	height = wf->small_rct.br.y - wf->small_rct.tl.y;
	
	target = d_alloc(sizeof(unsigned long)*(new_rct.br.x - new_rct.tl.x)*(new_rct.br.y - new_rct.tl.y));
	t_ptr = target;
	for ( y = new_rct.tl.y ; y < new_rct.br.y ; y ++) {
		ptr_x = &ix_x[new_rct.tl.x];
		for ( x = new_rct.tl.x ; x < new_rct.br.x ; x ++ , ptr_x ++ ) {
			if ( *ptr_x < 0 ) {
				t_ptr ++;
				continue;
			}
			yy = y - wf->small_rct.tl.y;
			xx = (*ptr_x) - wf->small_rct.tl.x;
			if ( yy < 0 || xx < 0 )
				*t_ptr = C_TRANSPARENT|C_DIRTY;
			else if ( xx >= width )
				*t_ptr = C_TRANSPARENT|C_DIRTY;
			else	*t_ptr = wf->pixels[xx + yy * width]|C_DIRTY;
			t_ptr ++;
		}
	}
	
	e2d_zoom_wa(wf->wa_set);
	d_f_ree(wf->pixels);
	wf->pixels = target;
	wf->small_rct = new_rct;
	wf->small_resize = 1;
	wf_check_small(gf,wf);
end:
	e2ds_get_weight(gf,wf);
	wf->flags |= WFF_DIRTY;
	return 0;
}

void
e1d_wf_insert_action_small(GBVIEW_FLAME * gf,WIN_FLAME * wf,int flags,int mov_base_distance,int mov_distance)
{
int total;
VPOINT from,to;
	total =  mov_base_distance + mov_distance;
	if ( total == 0 )
		return;
	from.x = to.x = 0;
	from.y = 0;
	to.y = total;
	e2ds_move(gf,wf,from,to,0);
}

int
e1d_overlay_small(GBVIEW_FLAME * gf,WIN_FLAME * wf,OV_ARG * a)
{
int top,bottom;
	top = gf->flame_base_y_offset + wf->e1d_y_top + wf->e1d_top_mergin;
	bottom = gf->flame_base_y_offset + wf->e1d_y_bottom + wf->e1d_bottom_mergin;
	if ( top >= gf->win_height )
		return 0;
	if ( bottom <= 0 )
		return 0;
	return e2ds_overlay(gf,wf,a);
}



int
e1ds_move(GBVIEW_FLAME * gf,WIN_FLAME * wf,VPOINT from,VPOINT to,
	 void * _ix)
{
int top,bottom;
int dy;
	dy = to.y - from.y;
	top = gf->flame_base_y_offset + wf->e1d_y_top + wf->e1d_top_mergin;
	bottom = gf->flame_base_y_offset + wf->e1d_y_bottom + wf->e1d_bottom_mergin;
	if ( dy > 0 )
		bottom += dy;
	else	top += dy;
	if ( top >= gf->win_height )
		return 0;
	if ( bottom <= 0 )
		return 0;
	return e2ds_move(gf,wf,from,to,_ix);
}



