/**********************************************************************
 
	Copyright (C) 2007 Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"change_endian.h"
#include	"memory_debug.h"
#include	"recordlist64.h"
#include	"matrix.h"
#include	"pg_vector.h"
#include	"xlerror.h"
#include	"xl_zlib.h"
#include	"mx_format.h"

void mem_test();
void gc_tick_notin_tick();

/*
	([mxPgPlotInsert id="mtx"] opt-list FieldData)
	FieldData:
		(	(label type data)
			....)
	Resolutions:
		( INT INT .... ) length of dim
	RETURN
	()
*/



XL_SEXP*
gb_gmxPgPlotInsert(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV* a,XL_SYM_FIELD * sf);

void
init_gmxPgPlotInsert(XLISP_ENV * env0,XLISP_ENV * env1)
{
	set_env(env1,l_string(std_cm,"gmxPgPlotInsert"),
		get_func_prim(gb_gmxPgPlotInsert,FO_NORMAL,0,3,3));
}

L_CHAR * next_s_ptr(L_CHAR * str,L_CHAR * e_ptr)
{
L_CHAR * np;
	if ( str >= e_ptr )
		return str;
	for ( ; *str && *str != ',' ; str ++ );
	if ( str >= e_ptr )
		return str;
	str ++;
	np = str;
	for ( ; *np && *np != ',' ; np ++ );
	*np = 0;
	return str;
}

void
set_zero_s_ptr(L_CHAR * str,L_CHAR * e_ptr)
{
	if ( str >= e_ptr )
		return;
	for ( ; *str && *str != ',' ; str ++ );
	*str = 0;
}

char * 
_insert_plot_data(MX_ENTRY * e,INTEGER64 * crd,int _ch,INTERNAL_PLOT * pt)
{
INTEGER64 * ix;
INTEGER64 * st,*end,*inc;
int i;
int dim;
MATRIX * m;
INTERNAL_PLOT * pt2;
int _ret;
char * err_msg;
int div;
MX_STRUCT_BLOCK * blk;
INTEGER64 mask;

ss_printf("IPD %s\n",pt_dc(e->c.m,crd,PTDC_NODE_ID));
	if ( crd[0] == 0 )
		return 0;
	m = e->c.m;
	dim = m->p.dim;
	st = mxc_alloc(&e->c,sizeof(INTEGER64)*(m->p.dim+1));
	end = mxc_alloc(&e->c,sizeof(INTEGER64)*(m->p.dim+1));
	inc = mxc_alloc(&e->c,sizeof(INTEGER64)*(m->p.dim+1));
	ix = mxc_alloc(&e->c,sizeof(INTEGER64)*(m->p.dim+1));
	for ( i = 0 ; i < dim ; i ++ ) {
		mask = -(((INTEGER64)1)<<(crd[0]*m->dim_divide[i]+m->block_size[i]));
		ix[i+1] = st[i+1] = crd[i+1] & mask;
		st[i+1] &= mask;
		end[i+1] = st[i+1] + (((INTEGER64)1)<<(crd[0]*m->dim_divide[i]+m->block_size[i]));
		inc[i+1] = ((INTEGER64)1)<<((crd[0]-1)*m->dim_divide[i]+m->block_size[i]);
	}
	ix[0] = st[0] = crd[0]-1;
	end[0] = crd[0]-1;
	inc[0] = crd[0]-1;
	for ( ; ; ) {
ss_printf("IPD-2 %s\n",pt_dc(e->c.m,ix,PTDC_NODE_ID));
		pt2 = shift_under_plot(m,pt,crd[0],ix);
		if ( pt2 == 0 )
{ss_printf("NONE\n");
			goto next;
}
		_ret = get_mx_cache(&e->c,ix);
ss_printf("IPD-3 %s\n",pt_dc(e->c.m,e->c.n->dim_code,PTDC_NODE_ID));
		err_msg = "cache error (Access to Matrix)";
		if ( _ret < 0 ) {
ss_printf("A\n");
			goto last;
		}
		blk = get_channel_struct_block(e->c.n,_ch);
		err_msg = "cannot get channel block";
		if ( blk == 0 ){
ss_printf("B\n");
//			matrix_node_channel_unlock(e->c.n,0);
			goto last;
		}
		err_msg = "operation of PLOT 1";
		_ret = (*blk_pp_tbl.operation)(PPC_SET,blk,pt2);
		if ( _ret < 0 ) {
ss_printf("C\n");
			matrix_node_channel_unlock(e->c.n,0);
			goto last;
		}
		div = (*blk_pp_tbl.operation)(PPC_DIVIDE_CHECK,blk,0);
		if ( div == 0 ) {
ss_printf("D\n");
			matrix_node_channel_unlock(e->c.n,NF_DIRTY);
			goto next;
		}
		(*blk_pp_tbl.operation)(PPC_GET_AND_CLEAR,blk,&pt2);
		matrix_node_channel_unlock(e->c.n,NF_DIRTY);
		e->c.dirty = NF_DIRTY;

		err_msg = _insert_plot_data(e,ix,_ch,pt2);
		free_internal_plot_list(pt2);
		if ( err_msg )
			goto last;
	next:
		if ( inc_dim_code_ix(ix,st,inc,end,dim) )
			break;
	}
	err_msg = 0;
last:
	mxc_free(&e->c,ix);
	mxc_free(&e->c,st);
	mxc_free(&e->c,end);
	mxc_free(&e->c,inc);
	return err_msg;
}

char * 
insert_point_data(MX_ENTRY * e,INTEGER64 * crd,int _ch,IP_FIELD * fdp)
{
char * err_msg;
int _ret;
int div;
INTEGER64 org_level,ins_level;
INTERNAL_PLOT * pt;
MATRIX * m;
MX_STRUCT_BLOCK * blk;
PPC_INSERT_T ins;


	m = e->c.m;
	org_level = crd[0];
	ins_level = m->total_levels-1;
	for ( ; ins_level > 0 ; ins_level -- ) {
		crd[0] = ins_level;
		_ret = get_mx_cache(&e->c,crd);
//ss_printf("INS_LEVEL %s\n",pt_dc(e->c.m,crd,PTDC_NODE_ID));
		err_msg = "cache error (Access to Matrix)";
		if ( _ret < 0 )
			return err_msg;
		if ( check_children(e->c.n) == 0 )
			break;
//		matrix_node_channel_unlock(e->c.n,NF_DIRTY);
	}
	blk = get_channel_struct_block(e->c.n,_ch);
	err_msg = "cannot get channel block";
	if ( blk == 0 )
		return err_msg;
	crd[0] = org_level;
	ins.crd = crd;
	ins.level = ins_level;
	ins.fields = fdp;
	err_msg = "operation of PLOT";
	_ret = (*blk_pp_tbl.operation)(PPC_INSERT,blk,&ins);
	if ( _ret < 0 ) {
		matrix_node_channel_unlock(e->c.n,0);
		return err_msg;
	}
	div = (*blk_pp_tbl.operation)(PPC_DIVIDE_CHECK,blk,0);
	if ( div == 0 ) {
		matrix_node_channel_unlock(e->c.n,NF_DIRTY);
		return 0;
	}
	(*blk_pp_tbl.operation)(PPC_GET_AND_CLEAR,blk,&pt);
	matrix_node_channel_unlock(e->c.n,NF_DIRTY);
	e->c.dirty = NF_DIRTY;
	crd[0] = ins_level;
ss_printf("INSERT PLOT DATA ==========================\n");
	err_msg = _insert_plot_data(e,crd,_ch,pt);
ss_printf("INSERT PLOT DATA END ======================\n");
	crd[0] = org_level;
	free_internal_plot_list(pt);
	return err_msg;
}


void
see_code(L_CHAR * str)
{
	ss_printf("SEE ");
	for ( ; *str ; str ++ )
		ss_printf(" %x",(unsigned int)*str);
	ss_printf("\n");
}

XL_SEXP*
gb_gmxPgPlotInsert(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV* a,XL_SYM_FIELD * sf)
{
MX_ENTRY * e;
XL_SEXP * d,* fdopt,*d1;
L_CHAR * id;
char * err_msg;
XL_SEXP * ret;
int _ret;
IP_FIELD * fd,* dim_fd;;
int i;
FD_OPT * fp;
FD_OPT_PTR * fdopt_ptr;
INTEGER64 * crd;
//PPC_INSERT_T ins;
//MX_STRUCT_BLOCK * blk;
int no;
L_CHAR * channel;
int _ch;
L_CHAR * csv;
XL_SEXP * str;
L_CHAR * _str,*s_ptr,*e_ptr;

INTEGER64 tim;
int cnt_nos;
/*
int gn_tree_node,gn_create,gn_wait;
*/
L_CHAR *  startline;
int _startline;
	ret = 0;
	id = get_sf_attribute(sf,l_string(std_cm,"id"));
	err_msg = "matrix id";
	if ( id == 0  )
		goto inv_param;
	e = search_mx_entry_by_id(atoi(n_string(std_cm,id)));
	if ( e == 0 )
		goto inv_param;
	gc_push(0,0,"gmxPgPlotInsert");
	d1 = eval(env,get_el(s,2));
	gc_pop(d1,gc_gb_sexp);
	if ( get_type(d1) == XLT_ERROR )
		return d1;
	fdopt = eval(env,get_el(s,1));
	err_msg = "fd option";

	switch ( get_type(fdopt) ) {
	case XLT_PTR:
		break;
	case XLT_ERROR:
		return fdopt;
	default:
		goto type_missmatch;
	}
	fdopt_ptr = (FD_OPT_PTR*)fdopt->ptr.ptr;
	err_msg = "matrix in the id and fd ptr";
	if ( fdopt_ptr->m != e->c.m )
		goto inv_param;
	channel = get_sf_attribute(sf,l_string(std_cm,"channel"));
	err_msg = "channel";
	if ( channel == 0 )
		goto inv_param;
	_ch = atoi(n_string(std_cm,channel));



	csv = get_sf_attribute(sf,l_string(std_cm,"csv"));
	if ( csv ) {
		startline = get_sf_attribute(sf,l_string(std_cm,"startline"));
		if ( startline )
			_startline = atoi(n_string(std_cm,startline));
		else	_startline = 0;
	
		flush_mx_cache(&e->c,0);

/*
		gn_tree_node = e->c.gn_tree_node;
		gn_create = e->c.gn_create;
		gn_wait = e->c.gn_wait;
		
		e->c.gn_tree_node = GN_TREE;
		e->c.gn_create = GN_LIST_CREATE;
		e->c.gn_wait = GN_LIST_CREATE;
*/
		push_gn(&e->c,
			GN_TREE,
			GN_LIST_CREATE,
			GN_LIST_CREATE
			);

		set_matrix_env(e->c.m,"create-node","enable");

		crd = d_alloc(sizeof(INTEGER64)*(e->c.m->p.dim+1));
		cnt_nos = 0;
		gc_push(d1,gc_gb_sexp,"gmxPgPlotInsert-0");
		gc_push(d1,gc_gb_sexp,"gmxPgPlotInsert-1");
		for ( ; _startline > 0 ; _startline -- , d1 = cdr(d1) , cnt_nos ++ );
		gc_pop(d1,gc_gb_sexp);
		for ( ; get_type(d1) == XLT_PAIR ; gc_push(d1,gc_gb_sexp,"cdr-gmx"), d1 = cdr(d1) ,gc_pop(d1,gc_gb_sexp),  cnt_nos ++ ) {
			gc_push(d1,gc_gb_sexp,"gmxPgPlotInsert-2");
if ( tim != get_xltime() ) {
ss_printf("CNT=%i\n",cnt_nos);
tim = get_xltime();
}

			ret = xli_break_check(s,10);
			if ( get_type(ret) == XLT_ERROR )
				break;


			str = car(d1);
			if ( get_type(str) != XLT_STRING ) {
				gc_pop(d1,gc_gb_sexp);
				continue;
			}
//see_code(str->string.data);
			_str = ll_copy_str(str->string.data);
			e_ptr = _str+l_strlen(_str);
			
			dim_fd = d_alloc(sizeof(IP_FIELD)*e->c.m->p.dim);
			memset(dim_fd,0,sizeof(IP_FIELD)*e->c.m->p.dim);
			fd = d_alloc(sizeof(IP_FIELD)*(fdopt_ptr->last_label+1));
			memset(fd,0,sizeof(IP_FIELD)*(fdopt_ptr->last_label+1));

			fd[0].len = fdopt_ptr->last_label+1;
			for ( i = 0 ; i < fd[0].len ; i ++ ) {
				fd[i].type = CH_NONE;
			}
			dim_fd[0].len = e->c.m->p.dim;
			for ( i = 0 ; i < dim_fd[0].len ; i ++ ) {
				dim_fd[i].type = CH_NONE;
			}
			fp = fdopt_ptr->opt;
			for ( ; fp->h.csv_label < 0 ; fp = fp->h.next ) {
				err_msg = "get data1";
//ss_printf("FP %x\n",fp->h.merge_type);
				_ret = 0;
				if ( fp->h.dim >= 0 )
					_ret = (*field_type_tbl[fp->h.merge_type>>CH_TYPE_SHIFT].initial)
						(&dim_fd[fp->h.dim],fp->h.init_sexp,fp,0);
				if ( _ret < 0 ) {
					gc_pop(0,0);
					goto error;
				}
				err_msg = "get data3";
				_ret = 0;
				if ( fp->h.target_label >= 0 )
					_ret = (*field_type_tbl[fp->h.merge_type>>CH_TYPE_SHIFT].initial)
						(&fd[fp->h.target_label],fp->h.init_sexp,fp,0);
				if ( _ret < 0 ) {
					gc_pop(0,0);
					goto error;
				}
			}
			no = 0;
			set_zero_s_ptr(_str,e_ptr);
			for ( s_ptr = _str ; s_ptr < e_ptr ; s_ptr = next_s_ptr(s_ptr,e_ptr)  , no ++ ) {
//ss_printf("s_ptr-1 = %ls %i %i\n",s_ptr,no,fp->h.csv_label);
				if ( fp->h.csv_label > no )
					continue;
//ss_printf("s_ptr-2 = %ls %i %i\n",s_ptr,no,fp->h.csv_label);

			retry:
				err_msg = "getDim1";
				_ret = 0;
				if ( fp->h.dim >= 0 )
					_ret = (*field_type_tbl[fp->h.merge_type>>CH_TYPE_SHIFT].initial)
						(&dim_fd[fp->h.dim],s_ptr,fp,1);
				if ( _ret < 0 ) {
					gc_pop(0,0);
//ss_printf("FP-3 err-1\n");
					goto error;
				}
				err_msg = "get data2";
				_ret = 0;
//ss_printf("FP-2 %x\n",fp->h.merge_type);
				if ( fp->h.target_label >= 0 )
					_ret = (*field_type_tbl[fp->h.merge_type>>CH_TYPE_SHIFT].initial)
						(&fd[fp->h.target_label],s_ptr,fp,1);
				if ( _ret < 0 ) {
					gc_pop(0,0);
//ss_printf("FP-3 err-2\n");
					goto error;
				}
				fp = fp->h.next;
				if ( fp == 0 )
					break;
				if ( fp->h.csv_label == no )
					goto retry;
			}
//ss_printf("FP-5 %p %p %x\n",s_ptr,e_ptr,*s_ptr);
			for ( i = 0 ; i < dim_fd[0].len ; i ++ ) {
				switch ( dim_fd[0].type & CH_TYPE_MASK) {
				case CH_TYPE_NONE:
					crd[i+1] = 0;
					break;
				case CH_TYPE_INT:
					crd[i+1] = dim_fd[i].d.i[0];
					break;
				default:
					err_msg = "dimmention data type missmatch";
					goto type_missmatch;
				}
			}
			crd[0] = 0;
			d_f_ree(_str);
			free_fields(dim_fd);
			
		//ss_printf("N=%p\n",e->c.n);
/*
			_ret = get_mx_cache(&e->c,crd);
			err_msg = "cache error (Access to Matrix)";
			if ( _ret < 0 )
				goto inv_param_error;
			blk = get_channel_struct_block(e->c.n,_ch);
			err_msg = "cannot get channel block";
			if ( blk == 0 )
				goto inv_param;
			ins.crd = crd;
			ins.level = crd[0];
			ins.fields = fd;
			err_msg = "operation of PLOT";
			_ret = (*blk_pp_tbl.operation)(PPC_INSERT,blk,&ins);
			if ( _ret < 0 ) {
				matrix_node_channel_unlock(e->c.n,0);
				goto inv_param_error;
			}
			matrix_node_channel_unlock(e->c.n,NF_DIRTY);
			e->c->dirty = NF_DIRTY;
*/

			err_msg = insert_point_data(e,crd,_ch,fd);
			if ( err_msg ) {
				gc_pop(0,0);
				goto inv_param;
			}
			free_fields(fd);
			gc_pop(d1,gc_gb_sexp);
		}
		d_f_ree(crd);
/*
		e->c.gn_tree_node = gn_tree_node;
		e->c.gn_create = gn_create;
		e->c.gn_wait = gn_wait;
*/
		pop_gn(&e->c);

		flush_mx_cache(&e->c,0);
		
		gc_pop(0,0);
	}
	else {

		dim_fd = d_alloc(sizeof(IP_FIELD)*e->c.m->p.dim);
		memset(dim_fd,0,sizeof(IP_FIELD)*e->c.m->p.dim);
		fd = d_alloc(sizeof(IP_FIELD)*(fdopt_ptr->last_label+1));
		memset(fd,0,sizeof(IP_FIELD)*(fdopt_ptr->last_label+1));

		fd[0].len = fdopt_ptr->last_label+1;
		for ( i = 0 ; i < fd[0].len ; i ++ ) {
			fd[i].type = CH_NONE;
		}
		dim_fd[0].len = e->c.m->p.dim;
		for ( i = 0 ; i < dim_fd[0].len ; i ++ ) {
			dim_fd[i].type = CH_NONE;
		}
		fp = fdopt_ptr->opt;
		for ( ; fp->h.csv_label < 0 ; fp = fp->h.next ) {
			_ret = 0;
			if ( fp->h.dim >= 0 )
				_ret = (*field_type_tbl[fp->h.merge_type>>CH_TYPE_SHIFT].initial)
					(&dim_fd[fp->h.dim],fp->h.init_sexp,fp,0);
			if ( _ret < 0 )
				goto error;
			err_msg = "get data";
			_ret = 0;
			if ( fp->h.target_label >= 0 )
				_ret = (*field_type_tbl[fp->h.merge_type>>CH_TYPE_SHIFT].initial)
					(&fd[fp->h.target_label],fp->h.init_sexp,fp,0);
			if ( _ret < 0 )
				goto error;
		}
		no = 0;
		for ( d = d1 ; get_type(d) == XLT_PAIR ; d = cdr(d) , no ++ ) {
			if ( fp->h.csv_label > no )
				continue;
		retry2:
			err_msg = "getDim";
			_ret = 0;
			if ( fp->h.dim >= 0 )
				_ret = (*field_type_tbl[fp->h.merge_type>>CH_TYPE_SHIFT].initial)
					(&dim_fd[fp->h.dim],car(d),fp,0);
			if ( _ret < 0 )
				goto error;
			err_msg = "get data";
			_ret = 0;
			if ( fp->h.target_label >= 0 )
				_ret = (*field_type_tbl[fp->h.merge_type>>CH_TYPE_SHIFT].initial)
					(&fd[fp->h.target_label],car(d),fp,0);
			if ( _ret < 0 )
				goto error;
			fp = fp->h.next;
			if ( fp == 0 )
				break;
			if ( fp->h.csv_label == no )
				goto retry2;
		}
		crd = d_alloc(sizeof(INTEGER64)*(dim_fd[0].len+1));
		for ( i = 0 ; i < dim_fd[0].len ; i ++ ) {
			switch ( dim_fd[0].type & CH_TYPE_MASK) {
			case CH_TYPE_NONE:
				crd[i+1] = 0;
				break;
			case CH_TYPE_INT:
				crd[i+1] = dim_fd[i].d.i[0];
				break;
			default:
				err_msg = "dimmention data type missmatch";
				goto type_missmatch;
			}
		}
		crd[0] = 0;
		free_fields(dim_fd);
		
	//ss_printf("N=%p\n",e->c.n);
/*
		_ret = get_mx_cache(&e->c,crd);
		err_msg = "cache error (Access to Matrix)";
		if ( _ret < 0 )
			goto inv_param_error;
		blk = get_channel_struct_block(e->c.n,_ch);
		err_msg = "cannot get channel block";
		if ( blk == 0 )
			goto inv_param;
		ins.crd = crd;
		ins.level = crd[0];
		ins.fields = fd;
		err_msg = "operation of PLOT";
		_ret = (*blk_pp_tbl.operation)(PPC_INSERT,blk,&ins);
		if ( _ret < 0 ) {
			matrix_node_channel_unlock(e->c.n,0);
			goto inv_param_error;
		}
		matrix_node_channel_unlock(e->c.n,NF_DIRTY);
		e->c->dirty = NF_DIRTY;

*/


		err_msg = insert_point_data(e,crd,_ch,fd);
		if ( err_msg )
			goto inv_param;


		free_fields(fd);
		d_f_ree(crd);
	}
	return ret;
error:
	ret = get_error(
		s->h.file,
		s->h.line,
		_ret,
		l_string(std_cm,"gmxPgPlotInsert"),
		List(n_get_string("type missmatch or others"),n_get_string(err_msg),-1));
	return ret;
type_missmatch:
	ret = get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"gmxPgPlotInsert"),
		List(n_get_string("type missmatch"),n_get_string(err_msg),-1));
	return ret;
inv_param:
	ret = get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"gmxPgPlotInsert"),
		List(n_get_string("invalid parameter in gmxPgPlotInsert"),n_get_string(err_msg),-1));
	return ret;
/*
inv_param_error:
	ret = get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"gmxPgPlotInsert"),
		List(n_get_string("invalid parameter in gmxPgPlotInsert"),n_get_string(err_msg),get_integer(_ret,0),-1));
	return ret;
*/
}
