/**********************************************************************

	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomohito Nakajima <nakajima@zeta.co.jp>
	Tomoki Sekiyama <sekiyama@yahoo.co.jp>

	This program is free software; you can redistribute it
	and/or modify it under the terms of the GLOBALBASE
	Library General Public License (G-LGPL) as published by

	http://www.globalbase.org/

	This program is distributed in the hope that it will be
	useful, but WITHOUT ANY WARRANTY; without even the
	implied warranty of MERCHANTABILITY or FITNESS FOR A
	PARTICULAR PURPOSE.

**********************************************************************/


#include "v/VObject.h"

extern "C"{
	#include "machine/v_types.h"
}

#include <map>

std::map<HWND, VInfo*> vinfo_ptr_map;
CRITICAL_SECTION vinfo_map_cs;

VContainerInfo *VInfo::get_container_info(VObject *object){
	VInfo *info = object->get_info_this();
	if ( info->is_container_window() )
		return dynamic_cast<VContainerInfo*>(info);
	return dynamic_cast<VContainerInfo*>(
		VInfo::get_from_hwnd(GetParent(info->get_hwnd())));
}

void VInfo::add_message_handler(MessageHandler *handler){
	for(int i=0;i<MAX_MESSAGE_HANDLER; ++i){
		if(message_handler[i]==0){
			message_handler[i] = handler;
			return;
		}
	}
	er_panic("too many message handler. if you want more handers, change MAX_MESSAGE_HANDLER or make message_handler resizable :)");
}

VInfo::VInfo(VObject *o, HWND h, int id):
	obj(o), hwnd(h),font(NULL),hfont(NULL),control_id(id)
{
	memset(message_handler, 0, sizeof(message_handler));

	EnterCriticalSection(&vinfo_map_cs);
	vinfo_ptr_map[hwnd] = this;
	LeaveCriticalSection(&vinfo_map_cs);

	// v_serialized_exec_sub(SetWindowLong, hwnd, GWL_USERDATA, (LONG)this);
}

VInfo::~VInfo()
{
	vinfo_ptr_map.erase(hwnd);
	if(hfont)
		DeleteObject(hfont);
	for(int i=0;i<MAX_MESSAGE_HANDLER;++i){
		if(message_handler[i]==0)
			break;
		delete message_handler[i];
	}
}

VFONT *VInfo::get_font(){
	if(font==NULL){
		font = get_win_gui_vfont();
	}
	return font;
}

void VInfo::set_font(VFONT *font)
{
	this->font = font;
	if(hfont)
		DeleteObject(hfont);
	hfont = CreateFontIndirectW(get_font());
	v_serialized_exec_sub(SendMessage, hwnd, WM_SETFONT, (UINT)hfont, 1);
}

VInfo *VInfo::get_from_hwnd(HWND hWnd){
	/*
	VInfo *ret = (VInfo*)::GetWindowLong(hWnd, GWL_USERDATA);
	return ret;
	*/
	VInfo* ret = NULL;
	
	EnterCriticalSection(&vinfo_map_cs);
	std::map<HWND,VInfo*>::iterator it = vinfo_ptr_map.find(hWnd);
	if(it != vinfo_ptr_map.end()){
		ret = it->second;
	}
	LeaveCriticalSection(&vinfo_map_cs);
	return ret;
}

void VInfo::init(){
	InitializeCriticalSection(&vinfo_map_cs);
}
