/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include <string.h>

#include "v/v_types.h"
#include "vwin_error.h"
#include "v/v_serialized_exec.h"

extern "C" {

#include "memory_debug.h"


void
v_image_new_m(VImage* img, short w, short h, char depth)
{
	BITMAPINFO bmi;
	bmi.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	bmi.bmiHeader.biWidth = w;
	bmi.bmiHeader.biHeight = -h;
	bmi.bmiHeader.biPlanes = 1;
	bmi.bmiHeader.biBitCount = 32;
	bmi.bmiHeader.biCompression = BI_RGB;
	bmi.bmiHeader.biSizeImage = w*h*4;
	bmi.bmiHeader.biXPelsPerMeter = 0;
	bmi.bmiHeader.biYPelsPerMeter = 0;
	bmi.bmiHeader.biClrUsed = 0;
	bmi.bmiHeader.biClrImportant = 0;
	img->info = CreateDIBSection(NULL, &bmi, DIB_RGB_COLORS,
								(void**)&img->buf_32, NULL, 0);
	if ( img->info == NULL ) {
		VWinError();
		er_panic("CreateDIBSection failure");
	}
	img->w_border = w;
}

void
v_image_free_m(VImage* img)
{
	DeleteObject(img->info);
	img->info = 0;
	img->buf_32 = 0;
}

void
v_image_draw_start_m(VImage* img)
{
}

void
v_image_draw_end_m(VImage* img)
{
}

VImage*
v_image_ref(VImage* img)
{
	extern VImage* _v_image_ref(VImage* img);
	return v_serialized_exec_func(_v_image_ref, img);
}

VImage*
v_image_unref(VImage* img)
{
	extern VImage* _v_image_unref(VImage* img);
	return v_serialized_exec_func(_v_image_unref, img);
}

// image lock - must be called via msequence from _m routine

bool
v_image_lock(VImage *img)
{
	if ( img->drawing )
		return false;
	img->drawing = true;
	v_image_draw_start_m(img);
	return true;
}

void
v_image_unlock(VImage *img)
{
	if ( ! img->drawing )
		er_panic("v_image_unlock");
	v_image_draw_end_m(img);
	img->drawing = false;
	wakeup_task((int)img);
}

bool
v_image_call_lock_m(VImage* img)
{
	extern bool v_image_lock(VImage *img);
	return v_serialized_exec_func(v_image_lock, img);
}

void 
v_image_call_unlock_m(VImage* img)
{
	extern void v_image_unlock(VImage *img);
	v_serialized_exec_sub(v_image_unlock, img);
}

} //extern "C"