/**********************************************************************

	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomohito Nakajima <nakajima@zeta.co.jp>
	Tomoki Sekiyama <sekiyama@yahoo.co.jp>

	This program is free software; you can redistribute it
	and/or modify it under the terms of the GLOBALBASE
	Library General Public License (G-LGPL) as published by

	http://www.globalbase.org/

	This program is distributed in the hope that it will be
	useful, but WITHOUT ANY WARRANTY; without even the
	implied warranty of MERCHANTABILITY or FITNESS FOR A
	PARTICULAR PURPOSE.

**********************************************************************/


#include "machine/gb_windows.h"
#include <winuser.h>
#include "VApplication.h"
#include "vwin_control.h"
#include "v/VButton.h"
#include "vobject_main.h"
#include "vwin_error.h"

extern "C" {
#include "memory_debug.h"
#include "utils.h"
#include "machine/msequence.h"
}


HWND CreateButtonWindow(int exStyle, int style, HWND hwnd, int id){
	return ::CreateWindowEx(
		exStyle, 
		"Button",
		"Button",
		style,
		0,
		0,
		0,
		0,
		hwnd,
		(HMENU)id,
		theApp->get_instance(),
		NULL);
}

void
VButton::destroy_do(VObject *parent)
{
	parent->remove_child_do(this);
	if(info){
		v_serialized_exec_sub(::DestroyWindow, info->get_hwnd());
		delete info;
		info = NULL;
	}
	sts.parent->redraw();
}

VButton::~VButton()
{
	// implemented in sub class.
}

VExError
VButton::get_status(VObjectStatus *s, int flags) const
{
	V_OP_START_EX
	VExError err = VObject::get_status(s,flags);
	win_control_default_get_status(info->get_hwnd(), s, flags, &err);
	V_OP_END
	return err;
};

VExError
VButton::set_status(const VObjectStatus *s, int flags)
{
	V_OP_START_EX
	
	VExError err = VObject::set_status(s,flags);
	HWND hwnd = info->get_hwnd();
	win_control_default_set_status(hwnd, s, flags&~VSF_DESC, &err);
	
	if ( flags & VSF_CALC_MIN ) {
		// min is calculated when desc is set
		err.subcode1 &= ~VSF_CALC_MIN;
	}
	
	if( (flags & VSF_DESC) && sts.vert_desc){
		LONG style = ::GetWindowLong(hwnd, GWL_STYLE);
		v_serialized_exec_sub(::SetWindowLong, hwnd, GWL_STYLE, style|BS_MULTILINE);
	}
	if ( flags & (VSF_DESC | VSF_VERTD | VSF_FSIZE | VSF_WS) ) {
		v_set_descriptor(info, sts.descriptor, sts.ws, sts.fsize, sts.vert_desc, &sts.min_size);
		sts.min_size.h += 4;
		sts.min_size.w += 4;

		err.subcode1 &= ~(VSF_DESC | VSF_VERTD | VSF_FSIZE | VSF_WS);
	}
		
	if ( flags & VSF_VISIBLE ) {
		if ( s->visible != (::IsWindowVisible(info->get_hwnd())==TRUE) ){
			v_serialized_exec_sub(::ShowWindow, hwnd, s->visible ? SW_SHOW : SW_HIDE);
		}
		err.subcode1 &= ~VSF_VISIBLE;
	}

	V_OP_END
	return err;
}

void
VButton::redraw(VRect *rect) const
{
	if ( ! info )
		return;
	_V_OP_START_VOID
	win_redraw(info->get_hwnd(), rect);
	V_OP_END
}
