/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"machine/include.h"
#include	"netutils.h"
#include	"memory_debug.h"

static char * dm_static;

char *
get_localdomainname()
{
FILE * fd;
int size;
char * dmp;
char * dm;
	size = 100;
	if ( dm_static )
		return dm_static;
	fd = fopen("/etc/resolv.conf","r");
	if ( fd == 0 ) {
		fprintf(stderr,"get_localdomainname error\n");
		return 0;
	}
	dm = 0;
	for ( ; ; ) {
		if ( dm )
			d_f_ree(dm);
		dm = d_alloc(size);
		if ( fgets(dm,size-1,fd) == 0 )
			break;
		if ( memcmp(dm,"domain",6) )
			continue;
		if ( dm[6] != ' ' && dm[6] != '\t' )
			continue;
		dmp = &dm[7];
		for ( ; *dmp == ' ' || *dmp == '\t' ; dmp ++ );
		strcpy(dm,dmp);
		for ( dmp = dm ; *dmp && *dmp != '\n' && *dmp != '\r' ;
				dmp ++);
		*dmp = 0;
		dm = d_re_alloc(dm,strlen(dm)+1);
		secure_fclose(fd);
		dm_static = dm;
		return dm;
	}
	if ( dm )
		d_f_ree(dm);
	secure_fclose(fd);
	dm_static = 0;
	return 0;
}
