/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include <stdio.h>
#include "gbf.h"
#include "long_char.h"
#include "memory_debug.h"
#include	"utils.h"
#include "machine/v_x11.h"

//#define DEBUG_PRINT

extern LC_DESCRIPTION_TABLE v_lcd_table[];

unsigned char *
gbf_write_char(L_CHAR c, LC_FONT * f,int size, GBF_OFS * ofs, int * pos)
{
LC_STRING_PIC p;
int w, h;
int i, j, type, len;
unsigned char * pixmap, *ptr;
LCF_SET str;

#ifdef DEBUG_PRINT
	printf("c = %x\t",c);
#endif
	
	if ( c == 0 ) {
		ofs->st_x = 0;
		ofs->st_y = 0;
		ofs->end_x = 0;
		ofs->end_y = 0;
		ofs->w = 0;
		ofs->type = 0;
		ofs->ofs = 0;
		return 0;
	}
	str.font = f;
	str.size = size;
	str.ch = c;

	v_get_string_pic(&p, VSD_V_L2R,&str,1);
	w = p.r.br.x - p.r.tl.x;
	h = p.r.br.y - p.r.tl.y;

#ifdef DEBUG_PRINT
	printf("(%d,%d)-(%d,%d) width = %d  ",p.r.tl.x, p.r.tl.y, p.r.br.x, p.r.br.y, p.width);
	printf("%d x %d  ", w, h);
	printf("pos = %d\n",*pos);

	for ( i = 0 ; i < h ; i++ ) {
		for ( j = 0 ; j < w ; j++ )
			printf("%c", p.pic[i*w+j] ? ' ' : 'o');
		printf("\n");
	}
#endif

	type = FT_SPACE;
	for ( i = 0 ; i < w*h ; i++ ) {
		if ( p.pic[i] != 0 && p.pic[i] != 255 ) {
			type = FT_GRAY;
			break;
		}
		if ( p.pic[i] == 0 )
			type = FT_BITMAP;
	}

	ofs->st_x = p.r.tl.x;
	ofs->st_y = p.r.tl.y;
	ofs->end_x = p.r.br.x;
	ofs->end_y = p.r.br.y;
	ofs->w = p.width;
	ofs->type = type;
	ofs->ofs = *pos;
	len = gbf_get_len(ofs);
	*pos += len;

	switch (type) {
	case FT_GRAY :
		pixmap = p.pic;
		break;
	case FT_BITMAP :
		ptr = pixmap = d_calloc(len,1);
		for ( i = 0 ; i < w*h ; ptr++ ) {
			for ( j = 7 ; j >= 0 && i < w*h ; i++, j-- )
				if ( p.pic[i] )
					*ptr |= 1 << j;
		}
		d_f_ree(p.pic);
		break;
	case FT_SPACE :
		d_f_ree(p.pic);
		pixmap = 0;
		break;
	}
	return pixmap;
}


void
gbf_load_a_font_size_specific(
	LC_FONT * f,
	VFONT_LIST * vfl,
	char * output_path,
	char * target_name,
	L_CHAR lcz,
	unsigned int nos)
{
char path[1000];
unsigned int i, pos, st_no, end_no, sp;
FILE * output_file;
GBF_HEADER * head;
GBF_OFS * ofs;
unsigned char ** pics;


 	head = d_calloc(sizeof(*head),1);
 	ofs = d_alloc(sizeof(*ofs)*nos);
 	pics = d_alloc(sizeof(*pics)*nos);
 
	sprintf(path, "%s/%s/%d.gbf", output_path,target_name,vfl->size);

	printf("output : %s\n", path);
	output_file = fopen(path,"w+");
	if ( output_file == 0 ) {
		perror("output");
		exit(1);
	}
	
	pos = 0;
	st_no = end_no = 1;
	for ( i = 1 ; i < nos ; i++ ) {
		pics[i] = gbf_write_char(lcz | i, f , vfl->size, ofs+i, &pos);
		if ( pics[i] || ( ofs[i].w != 0 && ofs[i].w != ofs[i].end_y - ofs[i].st_y ) ) {
			if ( st_no == 1 )
				st_no = i;
			end_no = i;
		}
	}
	end_no ++;
	nos = end_no - st_no;
	sp = sizeof(GBF_HEADER) + sizeof(GBF_OFS) * nos;
	for ( i = st_no ; i < end_no ; i++ )
		ofs[i].ofs += sp;
	
	strcpy(head->signature, "GBFONT");
	strcpy(head->fontname, vfl->name);
	head->size = vfl->size;
	head->st_no = st_no;
	head->end_no = end_no;
	head->nos = nos;
	
	printf("        range : %d-%d  nos : %d \n",st_no,end_no,nos);

	fwrite(head, sizeof(*head), 1, output_file);
	fwrite(ofs+st_no, sizeof(*ofs), nos, output_file);
	for ( i = st_no ; i < end_no ; i++ ) {
		if ( pics[i] ) {
			fwrite(pics[i], gbf_get_len(&ofs[i]), 1, output_file);
			d_f_ree(pics[i]);
		}
	}

	d_f_ree(head);
	d_f_ree(ofs);
	d_f_ree(pics);

//gbf_test(output_file);
	
	secure_fclose(output_file);
}


void
save_sizelist(VFONT * vf,char * output_path,char * font_name)
{
int i;
char * path;
FILE * file;
	path = d_alloc(strlen(output_path)+strlen(font_name)+100);
	sprintf(path,"%s/%s/sizelist.txt",output_path,font_name);
	file = fopen(path,"w+");
	d_f_ree(path);
	for ( i = 0 ; i < vf->vlist_len ; i ++ )
		fprintf(file,"%i\n",vf->vlist[i].size);
	fprintf(file,"end\n");
	secure_fclose(file);
}

void
gbf_load_a_font(
	VDISPLAY * d,
	LC_FONT * f,
	char * output_path)
{
VFONT * vf;
int i;
L_CHAR lcz;
int nos;
LC_FONT_WORK * w;
LC_DESCRIPTION_TABLE * get_vfont_size();
char * fontname, * p;
char dir[100];
	lcz = f->lcz[0];
	nos = - (int)f->mask[0];
	w = get_font_work(f,&d->fe);
	vf = (VFONT*)w->work;
	fontname = copy_str(vf->fontname);
	for ( p = fontname ; *p ; p ++ )
		if ( *p == '*' )
			*p = '_';

	sprintf(dir,"%s/%s",output_path,fontname);
	u_mkdir(dir,0755);
	save_sizelist(vf,output_path,fontname);
	for ( i = 0 ; i < vf->vlist_len ; i ++ ) {
		gbf_load_a_font_size_specific(f,&vf->vlist[i],
			output_path,fontname,lcz,nos);
	}
	d_f_ree(fontname);
}


void
gbf_load(char * output_path)
{
VDISPLAY * disp;
VERROR er;
LC_FONT * f;;
	disp = v_open_disp(&er);

er_panic("AAA");

	gbf_load_a_font(disp, f, output_path);
}
