/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include "v/VSlider.h"
#include "VReflector.h"
#include "CClickCheckAttachment.h"
#include "LView.h"

#include "LSlider.h"

VExError
VSlider::create_do(const VObjectStatus* s, int flags,VObject * nmp, void * arg)
{
	min = ((range_set*)arg)->min;
	max = ((range_set*)arg)->max;
	step = ((range_set*)arg)->step;

	SPaneInfo paneInfo;
	paneInfo.superView = dynamic_cast<LView*>(nmp->get_info_this());
	if ( paneInfo.superView == 0 )
		er_panic("non-LView object cannot be parent");
	paneInfo.paneID = sts.id;
	paneInfo.width = 0;
	paneInfo.height = 0;
	paneInfo.visible = true;
	paneInfo.enabled = true;
	paneInfo.left = 0;
	paneInfo.top = 0;
	paneInfo.bindings = (SBooleanRect){false,false,false,false};
	paneInfo.userCon = (long)this;
	int n = (max-min)/step;
	int al_stk = get_app_lock();
	LSlider *v = new LSlider(paneInfo, msg_ValueChanged, 0, 0, n,
							true, false, false, true, n<15?n+1:11);
	v->AddAttachment(new CClickCheckAttachment);
	v->FinishCreate();
	v->AddListener(new VReflector(this));
	info = v;
	release_app_lock(al_stk);
	return nmp->add_child_do(this);
}



void
VSlider::destroy_do(VObject * nmp)
{
	nmp->remove_child_do(this);
	int al_stk = get_app_lock();
	delete info;
	release_app_lock(al_stk);
	nmp->redraw();
}

VSlider::~VSlider()
{
}

VExError
VSlider::get_status(VObjectStatus *s, int flags) const
{
	V_OP_START_EX
	VExError err = v_get_status_standard(s, &flags, info);

	if ( flags & VSF_VALUE ) {
		int al_stk = get_app_lock();
		s->value = info->GetValue();
		s->value *= step;
		s->value += min;
		release_app_lock(al_stk);
		flags &= ~VSF_VALUE;
	}
	err.subcode1 = flags;

	VExError err2 = VObject::get_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);

	V_OP_END
	return err;
};

VExError
VSlider::set_status(const VObjectStatus *s, int flags)
{
	V_OP_START_EX
	VExError err = v_set_status_standard(s, flags, &sts, info);
	VExError err2 = VObject::set_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);

	if ( flags & VSF_VALUE ) {
		int al_stk = get_app_lock();
		int v = (s->value-min)/step;
		info->SetValue(v);
		release_app_lock(al_stk);
		err.subcode1 &= ~VSF_VALUE;
	}

	if ( flags & VSF_CALC_MIN ) {
		sts.min_size = (VSize){64,26};
		err.subcode1 &= ~VSF_CALC_MIN;
	}

	V_OP_END

	if ( flags & VSF_VISIBLE )
		VLayout::mark(this);

	return err;
}

void
VSlider::redraw(VRect *rect) const
{
	_V_OP_START()
	int al_stk = get_app_lock();
	if ( rect )
		info->RefreshRect((Rect){rect->t, rect->l, rect->b, rect->r});
	else
		info->Refresh();
	release_app_lock(al_stk);
	V_OP_END
}

