/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#define U_FILE_LIB

#include <stdio.h>
#include <errno.h>
#include	"machine/include.h"
#include	"u_file.h"
#include	"utils.h"
#include	"memory_debug.h"

int
u_open(char * filename,int flags,int mode)
{
force_scheduling();
	return open(filename,flags,mode);
}


int
u_close(int fd)
{
force_scheduling();
	return secure_close(fd);
}

int
u_write(int fd,void * data,int len)
{
force_scheduling();
	return write(fd,data,len);
}

int
u_read(int fd,void * data,int len)
{
force_scheduling();
	return read(fd,data,len);
}

int
u_lseek(int fd,int ofs,int where)
{
force_scheduling();
	return lseek(fd,ofs,where);
}

int
u_open64(char * filename,int flags,int mode)
{
	return open64(filename,flags,mode);
}

INTEGER64
u_lseek64(int fd,INTEGER64 ofs,int where)
{
int ret;
	ret = lseek64(fd,ofs,where);
	return ret;
}

int
u_unlink(char * path)
{
	return unlink(path);
}

int
u_rmdir(char * path)
{
	return rmdir(path);
}


char *
u_getenv(char * name)
{
	return getenv(name);
}


int u_checksum(int a,U_CK_BUF*b)
{
	return 0;
}
