/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


// ===========================================================================
//	CDataBrowser.h                                 2004.3.16   Tomoki Sekiyama
// ===========================================================================

#ifndef _H_CDataBrowser
#define _H_CDataBrowser
#pragma once

#include <LControlPane.h>
#include <LBroadcaster.h>

#if PP_Uses_Pragma_Import
	#pragma import on
#endif

PP_Begin_Namespace_PowerPlant

// ---------------------------------------------------------------------------

class	CDataBrowser : public LControlPane,
					   public LPeriodical,
					   public LCommander {
public:
	enum {	class_ID		= FOUR_CHAR_CODE('DatB'),
			imp_class_ID	= FOUR_CHAR_CODE('iDtB') };

						CDataBrowser(
								LStream*		inStream,
								ClassIDT		inImpID = imp_class_ID);

						CDataBrowser(
								const SPaneInfo&	inPaneInfo,
								LCommander*			inSuper,
								bool				hasHorizonalScrollBar = true,
								bool				hasVerticalScrollBar = true,
								Rect				*scrollBarInset = 0,
								bool				drawFocusRing = false,
								ResIDT				inTextTraitsID = 0,
								ClassIDT			inImpID = imp_class_ID);

	virtual				~CDataBrowser();

	virtual void		SetDisclosureColumn(
								UInt32			id);

	virtual void		SetSelectionFlag(
								DataBrowserSelectionFlags	flag);

	virtual void		AddColumn(
								UInt32			id,
								UInt32			type,
								UInt16			minWidth,
								UInt16			maxWidth,
								UInt32			flag = 0,
								const char *	title = NULL,
								UInt32			index = kDataBrowserListViewAppendColumn);
	
	virtual void		RemoveColumn(
								UInt32			id);

	virtual OSStatus	AddItem(
								DataBrowserItemID	id,
								DataBrowserItemID	container = 0)
		{ return AddItem(1,&id,container); }

	virtual OSStatus	AddItem(
								UInt32				num,
								DataBrowserItemID	*id,
								DataBrowserItemID	container = 0);

	virtual OSStatus	RemoveItem(
								DataBrowserItemID	id,
								DataBrowserItemID	container = 0)
		{ return RemoveItem(1,&id,container); }


	virtual OSStatus	RemoveItem(
								UInt32				num,
								DataBrowserItemID	*id,
								DataBrowserItemID	container = 0);

	virtual OSStatus	UpdateItem(
								DataBrowserItemID	container = 0,
								DataBrowserItemID	id = kDataBrowserNoItem,
								UInt32				propertyID = 0);

	virtual void		GetSelectedItems(
								Handle&			outSelection,
								UInt32&			outCount);

	virtual Boolean		ObeyCommand(
								CommandT		inCommand,
								void*			ioParam);

	virtual void		FindCommandStatus(
								CommandT		inCommand,
								Boolean&		outEnabled,
								Boolean&		outUsesMark,
								UInt16&			outMark,
								Str255			outName);

	virtual Boolean		HandleKeyPress( const EventRecord	&inKeyEvent );

	OSStatus			(*mItemDataFunc)(
								CDataBrowser *			pane,
								DataBrowserItemID		item,
								DataBrowserPropertyID	property,
								DataBrowserItemDataRef	itemData,
								Boolean					setValue);

	void				(*mItemNotifFunc)(
								CDataBrowser *				pane,
								DataBrowserItemID			item,
								DataBrowserItemNotification message);

	EventRecord			reservedEvent;
	bool				dispatch_flag;

	void			_HandleClick(
					SMouseDownEvent inMacEvent);

protected:
	virtual void		InitDataBrowser(
								bool	hasHorizonalScrollBar,
								bool	hasVerticalScrollBar,
								Rect	*scrollBarInset,
								bool	drawFocusRing);
	
	virtual void		ClickSelf( const SMouseDownEvent& inMouseDown );

	virtual void		BeTarget();
	virtual void		DontBeTarget();

	virtual void		HideSelf();
	virtual void		DisableSelf();
	
	virtual void		SpendTime( const EventRecord& inMacEvent );

private:

	static pascal OSStatus	ItemDataProc(
								ControlRef				browser,
								DataBrowserItemID		item,
								DataBrowserPropertyID	property,
								DataBrowserItemDataRef	itemData,
								Boolean					setValue);
   

	static pascal void	ItemNotificationProc(
								ControlRef					browser,
								DataBrowserItemID			item,
								DataBrowserItemNotification message);


	UInt32			mDisclosureColumnID;
	bool			mDrawFocusRing;

	friend class CDataBrowserImp;
};

PP_End_Namespace_PowerPlant


#if PP_Uses_Pragma_Import
	#pragma import reset
#endif

#endif
