#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <shlwapi.h>

#pragma comment(lib, "shlwapi.lib")

//#define IDR_COSMOS_CAB                  129
#include "..\CosmosInstaller\Resource.h"

bool AddResource(const char *exe_path,const char *cab_path)
{
	HANDLE hFile = CreateFile(cab_path, GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if (hFile == INVALID_HANDLE_VALUE) 	return false;
	bool bRet=true;
	DWORD size=GetFileSize(hFile,NULL),dwRead=0;
	char *buf=new char[size];
	ReadFile(hFile,buf,size,&dwRead,NULL);
	CloseHandle(hFile);
	HANDLE h=BeginUpdateResource(exe_path,FALSE);
	if (h)
	{
		if (UpdateResource(
			h,
			"BIN",//  LPCTSTR lpType,
			MAKEINTRESOURCE(IDR_COSMOS_CAB),
			MAKELANGID(LANG_JAPANESE, SUBLANG_DEFAULT), //  WORD wLanguage, // \[X̌ꎯʎq
			buf,
			size
		)==FALSE) bRet=false;
		if (EndUpdateResource(h,FALSE)==FALSE) bRet=false;;
	}
	else bRet=false;
	delete []buf;
	return bRet;
}


int main(int ac,char **av)
{
	if (ac!=3)
	{
		printf("ResourceExchange exe_file_name cab_file_name\n");
		return 0;
	}
	char *exe_path=av[1];
	char *cab_path=av[2];
	if (PathFileExists(exe_path) && PathFileExists(cab_path) && strnicmp(PathFindExtension(exe_path),".exe",4)==0)
	{
		if (AddResource(exe_path,cab_path)==true)
		{
			if(GetUserDefaultLCID() == 1041){
				printf("%s̃\[X%sŒu܂B\n",exe_path,cab_path);
			}
			else{
				printf("Exchanged %s's resource for %s.\n",exe_path,cab_path);
			}
			return 1;
		}
		else
		{
			if(GetUserDefaultLCID() == 1041){
				printf("%s̃\[X̒uɎs܂B\n",exe_path);
			}
			else{
				printf("Failed to exchange %s's resource.\n",exe_path);
			}
			return 0;
		}
	}
	if(GetUserDefaultLCID() == 1041){
		printf("słB\n");
	}
	else{
		printf("arguments error.\n");
	}
	return 0;
}


