/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<fcntl.h>
#include	"mlong_char.h"
#include	"memory_routine.h"
#include	"xl.h"
#include	"lock_level.h"
#include	"task.h"
#include	"init.h"

void gc_gb_file();
extern SEM lex_lock;

int
lexmain(int argc,char ** argv)
{
int t;
XL_FILE * f;
XL_SYM_FIELD * sf;
int tt;
	init_task(INI_WDONTCARE);
	init_longchar(); 
	init_stream();
/*
	xlsh_init_fd();
*/
	minit();
	init_utils();
	init_parse_system();
	lex_lock = new_lock(LL_LEX);

	f = mmalloc(sizeof(XL_FILE),gc_gb_file);
	gb_file_insert(f);
	f->flags = XLF_X_NO_CR|XLF_X_NO_SP;
	f->name = nl_copy_mstr(std_cm,"xlsh");
	f->st = s_open_file(argv[2],O_RDONLY);
	f->cm = get_default_cm();
	f->cm_work = (*f->cm->open)();
	f->mode = 0;
	f->line = 1;
	f->token_head_line = 1;
	new_entity(f,l_string(std_cm,"lt"),l_string(std_cm,"&#x3c;"));
	new_entity(f,l_string(std_cm,"amp"),l_string(std_cm,"&#x26;"));
	new_entity(f,l_string(std_cm,"quot"),l_string(std_cm,"&#x27;"));
	t = 1;
	for ( ; t ; ) {
		t = gb_lex(f);
		if ( t == 0 )
			break;
		if ( f->sexp ) {
			if ( t < 0x20 )
				tt = ' ';
			else if ( t >= 0x100 )
				tt = ' ';
			else	tt = t;
			printf("<%i> %x[%c] -",f->sexp->h.line,t,tt);
			switch ( f->sexp->h.type ) {
			case GBT_STRING:
				printf("str- \"%s\"\n",
					n_string(std_cm,f->sexp->string.data));
				break;
			case GBT_SYMBOL:
				printf("sym- %s\n",
					n_string(std_cm,f->sexp->symbol.data));
				for ( sf = f->sexp->symbol.field;
						sf; sf = sf->next ) {
					printf("\t\t%s = %s\n",
						n_string(std_cm,
							sf->name),
						n_string(std_cm,
							sf->data));
				}
				break;
			case GBT_INTEGER:
				printf("int- %i\n",
					f->sexp->integer.data);
				if ( f->sexp->integer.unit )
					printf("\t\t%s\n",
					n_string(std_cm,
						 f->sexp->integer.unit));
				break;
			case GBT_FLOAT:
				printf("flo- %lf\n",
					f->sexp->floating.data);
				if ( f->sexp->floating.unit )
					printf("\t\t%s\n",
					n_string(std_cm,
						 f->sexp->floating.unit));
				break;
			default:
				printf("default(%i)-\n",f->sexp->h.type);
			}
		}
		else	printf("<%i> %i[%c]\n",f->line,t,t);
	}
	print_sexp(s_stdout,f->lex_error,PF_RAW_DISABLE|PF_MULTI_ROOT);
	return 0;
}

int
parsemain(int argc,char ** argv)
{
XL_SEXP * s;
	init_task(INI_WDONTCARE);
	init_longchar();
	init_stream();
	minit();
	init_utils();
	init_gblisp();
	init_parse_system();

	s = init_parse(s_open_file(argv[2],O_RDONLY),
		       l_string(std_cm,"foo3"),
			l_string(std_cm,"foo3"));
	if ( strcmp(argv[1],"-html") == 0 )
		s->h.file->flags |= XLF_HTML|XLF_TEXT;
	for ( ; get_type(s) ; s = cdr(s) ) {
		printf("= ");
		print_sexp(s_stdout,car(s),PF_RAW_DISABLE|PF_INDENT|PF_XML);
		printf("\n");
	}
	return 0;
}
