/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"xl.h"
#include	"xlerror.h"

XL_SEXP *
gb_define(XLISP_ENV * e,XL_SEXP * s)
{
XL_SEXP * def;
XL_SEXP * dat;
	def = get_el(s,1);
	switch ( get_type(def) ) {
	case GBT_SYMBOL:
		dat = eval(e,get_el(s,2));
		break;
	case GBT_PAIR:
		dat = gb_lambda(e,
			append(	list(	n_get_symbol("lambda"),
					cdr(def),
					0),
				cdr(cdr(s))));
		def = car(def);
		break;
	default:
		return get_error(
			def->h.file,
			def->h.line,
			XLE_SEMANTICS_REQ_SYMBOL,
			l_string(std_cm,"define"),
			list(	n_get_string(
			"symbol is required for 1st parameter"),
				0));
	}
	if ( get_type(dat) == GBT_ERROR )
		return dat;
	set_env(e,def->symbol.data,dat);
	return def;
}
