/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"

XL_SEXP *
gb_Not(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * ret;
	ret = get_el(s,1);
	switch ( get_type(ret) ) {
	case GBT_ERROR:
		return ret;
	case GBT_INTEGER:
		if ( ret->integer.data != 0 )
			return get_integer(0,0);
		else	return get_integer(1,0);
	case GBT_FLOAT:
		if ( ret->floating.data != 0 )
			return get_integer(0,0);
		else	return get_integer(1,0);
	default:
		return get_error(
			s->h.file,
			s->h.line,
			XLE_SEMANTICS_TYPE_MISSMATCH,
			l_string(std_cm,"Not"),
			0);
	}
}
