/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"xl.h"
#include	"xlerror.h"

XL_SEXP *
set_line_fix(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * no;
	no = eval(env,get_el(s,1));
	switch ( get_type(no) ) {
	case GBT_ERROR:
		return no;
	case GBT_INTEGER:
		s->h.file->line = no->integer.data;
		s->h.file->flags |= XLF_FIX_LINE;
		break;
	default:
		return get_error(
			s->h.file,
			s->h.line,
			XLE_SEMANTICS_TYPE_MISSMATCH,
			l_string(std_cm,"set-line-fix"),
			list( n_get_string("type missmatch"),
				0));
	}
	return 0;
}
