/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"xl.h"


void
search_inh(XL_FILE ** f,int * line,XL_SEXP * s)
{
	for ( ; s && s->h.type == GBT_PAIR ; ) {
		if ( s->h.file ) {
			*f = s->h.file;
			*line = s->h.line;
			return;
		}
		search_inh(f,line,s->pair.car);
		s = s->pair.cdr;
	}
	if ( s == 0 )
		return;
	if ( s->h.file ) {
		*f = s->h.file;
		*line = s->h.line;
	}
}

void
_set_inh(XL_FILE * f,int line,XL_SEXP * s)
{
	for ( ; s && s->h.type == GBT_PAIR ; ) {
		_set_inh(f,line,s->pair.car);
		if ( s->h.file == 0 ) {
			s->h.file = f;
			s->h.line = line;
		}
		s = s->pair.cdr;
	}
	if ( s == 0 )
		return;
	if ( s->h.file == 0 ) {
		s->h.file = f;
		s->h.line = line;
	}
}

/*

void
set_inh(XL_SEXP * s)
{
XL_FILE * file;
int line;
	file = 0;
	search_inh(&file,&line,s);
	if ( file == 0 )
		return;
	_set_inh(file,line,s);
}

*/
