/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"xl.h"
#include	"memory_routine.h"
#include	"task.h"

extern SEM gb_env_lock;

void
del_env(XLISP_ENV * env,L_CHAR * sym)
{
int key;
ELEMENT ** ep;

	for ( ; env ; ) {
		switch ( env->type ) {
		case GBET_PAIR:
			del_env(env->p.env[0],sym);
			env = env->p.env[1];
			continue;
		case GBET_ENV:
			key = hash_key(sym);
			lock_task(gb_env_lock); 
			for ( ep = &env->e.hash[key] ;
					*ep ; ep = &(*ep)->next )
				if ( l_strcmp((*ep)->sym,sym) == 0 ) {
					*ep = (*ep)->next;
					unlock_task(gb_env_lock,
						"del_env"); 
					return;
				}
			unlock_task(gb_env_lock,"del_env"); 
			env = env->e.parent;
			continue;
		default:
			er_panic("del_env");
		}
	}
}


void
del_default_env(XLISP_ENV * env)
{
	for ( ; env ; ) {
		switch ( env->type ) {
		case GBET_PAIR:
			del_default_env(env->p.env[0]);
			env = env->p.env[1];
			continue;
		case GBET_ENV:
			lock_task(gb_env_lock);
			if ( env->e.default_sym == 0 ) {
				unlock_task(gb_env_lock,
					"del_default_env");
				return;
			}
			env->e.default_sym = 0;
			unlock_task(gb_env_lock,"del_default_env");
			return;
		}
	}
}

