/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<string.h>
#include	"xl.h"

int
cmp_sexp(XL_SEXP * a,XL_SEXP * b)
{
int ret;
	if ( get_type(a) != get_type(b) )
		return -1;
	switch ( get_type(a) ) {
	case GBT_NULL:
		return 0;
	case GBT_PAIR:
		if ( cmp_sexp(car(a),car(b)) )
			return -1;
		if ( cmp_sexp(cdr(a),cdr(b)) )
			return -1;
		return 0;
	case GBT_SYMBOL:
		if ( l_strcmp(a->symbol.data,b->symbol.data) )
			return -1;
		return 0;
	case GBT_STRING:
		ret = l_strcmp(a->string.data,b->string.data);
		if ( ret < 0 )
			return -1;
		if ( ret > 0 )
			return 1;
		return 0;
	case GBT_INTEGER:
	case GBT_FLOAT:
	default:
		er_panic("cmp_sexp(1)");
	}
	return 0;
}
