/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"


XL_SEXP * xl_StringLength();

void
init_StringLength(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"StringLength"),
		get_func_prim(xl_StringLength,FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
xl_StringLength(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * str;
int len;
	str = get_el(s,1);
	if ( get_type(str) != GBT_STRING ) {
		return get_error(
			s->h.file,
			s->h.line,
			XLE_SEMANTICS_TYPE_MISSMATCH,
			l_string(std_cm,"StringLength"),
			list(	n_get_string("invalid string in StringLength argument"),
				0));
	}
	len = l_strlen(str->string.data);
	if ( len >= 0 ){
		return get_integer(len,0);
	}
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"StringLength"),
		list(	n_get_string("invalid string in StringLength argument"),
			0));
}
