/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"


XL_SEXP * xl_SetParentEnvironment();

void
init_SetParentEnvironment(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"SetParentEnvironment"),
		get_func_prim(xl_SetParentEnvironment,FO_APPLICATIVE,0,3,3));
}

XL_SEXP *
xl_SetParentEnvironment(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * child;
XL_SEXP * parent;
	child = get_el(s,1);
	parent = get_el(s,2);
	if ( (get_type(child) != GBT_ENV) ||
	     (get_type(parent) != GBT_ENV &&
	      get_type(parent) != GBT_NULL) ) {
		return get_error(
			s->h.file,
			s->h.line,
			XLE_SEMANTICS_TYPE_MISSMATCH,
			l_string(std_cm,"SetParentEnvironment"),
			list(	n_get_string("SetParentEnvironment argument"),
				0));

	}
	switch ( child->env.data->type ) {
	case GBET_PAIR:
		switch ( get_type(parent) ) {
		case GBT_NULL:
			child->env.data->p.env[0] = 0;
			break;
		case GBT_ENV:
			child->env.data->p.env[0] = parent->env.data;
			break;
		}
		break;
	case GBET_ENV:
		switch ( get_type(parent) ) {
		case GBT_NULL:
			child->env.data->e.parent = 0;
			break;
		case GBT_ENV:
			child->env.data->e.parent = parent->env.data;
			break;
		}
		break;
	default:
		er_panic("xl_SetParentEnvironment");
	}
	return (XL_SEXP *)0;
}
