/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"

XL_SEXP * xl_SetMainInterpreter();


void
init_SetMainInterpreter(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"SetMainInterpreter"),
		get_func_prim(xl_SetMainInterpreter,
			FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
xl_SetMainInterpreter(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * id;
int _id;
extern XL_INTERPRETER * main_interpreter;
XL_INTERPRETER * xli;
	id = get_el(s,1);
	switch ( get_type(id) ) {
	case GBT_ERROR:
		return id;
	case GBT_INTEGER:
		_id = id->integer.data;
		break;
	case GBT_FLOAT:
		_id = id->floating.data;
		break;
	default:
		goto type_missmatch;
	}
	if ( _id < 0 ) {
		main_interpreter = 0;
	}
	else {
		xli = search_xli_id(_id);
		if ( xli == 0 )
			return get_error(
				s->h.file,
				s->h.line,
				XLE_PROTO_UNDEF_RESOURCE,
				l_string(std_cm,"MainInterpreter"),
				n_get_string("undefined iid"));
		main_interpreter = xli;
	}
	return 0;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"MainInterpreter"),
		list(	n_get_string("type missmatch"),
			id,0));
}

