/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"

XL_SEXP * xl_SetLogPath();


void
init_SetLogPath(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"SetLogPath"),
		get_func_prim(xl_SetLogPath,FO_APPLICATIVE,0,4,4));
}

XL_SEXP *
xl_SetLogPath(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * SetLogPath;
int _size,_no;
XL_SEXP * size,* no;
	SetLogPath = get_el(s,1);
	if ( get_type(SetLogPath) != GBT_STRING )
		goto type_missmatch;
	size = get_el(s,2);
	if ( get_type(size) != GBT_INTEGER )
		goto type_missmatch;
	_size = size->integer.data;
	no = get_el(s,3);
	if ( get_type(no) != GBT_INTEGER )
		goto type_missmatch;
	_no = no->integer.data;
	set_log_path(SetLogPath->string.data,_size,_no);
	return 0;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"SetLogPath"),
		0);
}



