/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/




#include	"xlerror.h"
#include	"xl.h"


XL_SEXP * xl_Remote();

void
init_Remote(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"Remote"),
		get_func_prim(xl_Remote,FO_NORMAL,0,3,-1));
}

XL_SEXP *
xl_Remote(XLISP_ENV * env,XL_SEXP * s)
{
int _id;
XL_SEXP * id;
XL_SEXP * ret;
int len,i;
	id = eval(env,get_el(s,1));
	switch ( get_type(id) ) {
	case GBT_ERROR:
		return id;
	case GBT_INTEGER:
		break;
	default:
		goto type_missmatch;
	}
	len = list_length(s);
	if ( len < 0 ) {
		for ( ; ; s = cdr(s) ) {
			if ( get_type(s) != GBT_ERROR )
				continue;
			return s;
		}
	}
	_id = id->integer.data;
	for ( i = 2 ; i < len ; i ++ ) {
		ret = remote_query(_id,env,0,get_el(s,i));
		if ( get_type(ret) == GBT_ERROR )
			return ret;
	}
	return ret;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"Remote"),
		n_get_string("type missmatch"));
}

