/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"


XL_SEXP * xl_NewEnvironment();

void
init_NewEnvironment(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"NewEnvironment"),
		get_func_prim(xl_NewEnvironment,FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
xl_NewEnvironment(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * parent;
	parent = get_el(s,1);
	switch ( get_type(parent) ) {
	case 0:
		return get_env(new_env(0));
	case GBT_ENV:
		return get_env(new_env(parent->env.data));
	default:
		return get_error(
			s->h.file,
			s->h.line,
			XLE_SEMANTICS_TYPE_MISSMATCH,
			l_string(std_cm,"NewEnvironment"),
			list(	n_get_string("NewEnvironment argument"),
				0));

	}
}
