/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"

XL_SEXP * xl_MoveDefine();


void
init_MoveDefine(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"MoveDefine"),
		get_func_prim(xl_MoveDefine,FO_NORMAL,0,4,4));
}

XL_SEXP *
xl_MoveDefine(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * from, * to;
XL_SEXP * sym, * data;
XLISP_ENV * _from,* _to;
	sym = get_el(s,1);
	switch ( get_type(sym) ) {
	case GBT_ERROR:
		return sym;
	case GBT_SYMBOL:
		break;
	default:
		goto type_missmatch;
	}
	from = eval(env,get_el(s,2));
	switch ( get_type(from) ) {
	case GBT_ERROR:
		return from;
	case GBT_ENV:
		_from = from->env.data;
		break;
	default:
		goto type_missmatch;
	}
	to = eval(env,get_el(s,3));
	switch ( get_type(to) ) {
	case GBT_ERROR:
		return to;
	case GBT_ENV:
		_to = to->env.data;
		break;
	default:
		goto type_missmatch;
	}
	if ( _to->type != GBET_ENV )
		goto invalid_param;
	data = eval(_from,sym);
	if ( get_type(data) == GBT_ERROR )
		return data;
	del_env(_from,sym->symbol.data);
	set_env(_to,sym->symbol.data,data);
	return sym;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"MoveDefine"),
		0);
invalid_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"MoveDefine"),
		n_get_string("invalid environment"));
}


