/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/




#include	"xlerror.h"
#include	"xl.h"


XL_SEXP * xl_Local();

void
init_Local(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"Local"),
		get_func_prim(xl_Local,FO_NORMAL,0,2,-1));
}

XL_SEXP *
xl_Local(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * ret;
int len,i;

	len = list_length(s);
	if ( len < 0 ) {
		for ( ; ; s = cdr(s) ) {
			if ( get_type(s) != GBT_ERROR )
				continue;
			return s;
		}
	}
	for ( i = 1 ; i < len ; i ++ ) {
		ret = local_query(env,0,get_el(s,i));
		if ( get_type(ret) == GBT_ERROR )
			return ret;
	}
	return ret;
}

