/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<stdlib.h>
#include	"xlerror.h"
#include	"xl.h"

XL_SEXP * xl_GetVariable();

void
init_GetVariable(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"GetVariable"),
		get_func_prim(xl_GetVariable,FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
xl_GetVariable(XLISP_ENV * env,XL_SEXP * s)
{
char * data;
XL_SEXP * v;
	v = get_el(s,1);
	switch ( get_type(v) ) {
	case GBT_ERROR:
		return v;
	case GBT_STRING:
		break;
	default:
		goto type_missmatch;
	}
	data = getenv(n_string(std_cm,v->string.data));
	if ( data == 0 )
		return get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_UNDEF_RESOURCE,
			l_string(std_cm,"GetEnvVar"),
			n_get_string("undefined evironment variable"));
	return get_string(l_string(std_cm,data));
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"Arg"),
		0);
}

