/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"memory_debug.h"
#include	"utils.h"
#include	"xlerror.h"
#include	"xl.h"


XL_SEXP * xl_GetURL();

void
init_GetURL(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"GetURL"),
		get_func_prim(xl_GetURL,FO_APPLICATIVE,0,2,2));
}




XL_SEXP *
xl_GetURL(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * url;
URL u;
XL_SEXP * ret;
	url = get_el(s,1);
	switch ( get_type(url) ) {
	case GBT_ERROR:
		return url;
	case GBT_STRING:
		break;
	default:
		goto type_missmatch;
	}
	get_url2(&u,url->string.data,1204);
	if ( u.resource )
		ret = cons(get_string(u.resource),0);
	else	ret = cons(0,0);
	if ( u.db )
		ret = cons(get_string(u.db),ret);
	else	ret = cons(0,ret);
	if ( u.port )
		ret = cons(get_integer(u.port,0),ret);
	else	ret = cons(get_integer(0,0),ret);
	if ( u.server )
		ret = cons(get_string(u.server),ret);
	else	ret = cons(0,ret);
	if ( u.proto )
		ret = cons(get_string(u.proto),ret);
	else	ret = cons(0,ret);
	free_url(&u);
	return ret;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"GetURL"),
		0);
}

