/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"ex_matrix.h"
#include	"xlerror.h"
#include	"xl.h"
#include	"associate.h"

XL_SEXP * xl_GetUnit();

void
init_GetUnit(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"GetUnit"),
		get_func_prim(xl_GetUnit,FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
xl_GetUnit(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf)
{
XL_SEXP * ss;
	ss = get_el(s,1);
	switch ( get_type(ss) ) {
	case GBT_INTEGER:
		return get_string(ss->integer.unit);
	case GBT_FLOAT:
		return get_string(ss->floating.unit);
	}
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"GetUnit"),
		n_get_string("type missmatch"));
}

