/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"


XL_SEXP * xl_GetTag();

void
init_GetTag(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"GetTag"),
		get_func_prim(xl_GetTag,FO_APPLICATIVE,0,2,2));
}


XL_SEXP *
xl_GetTag(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * sym;
	sym = get_el(s,1);
	if ( get_type(sym) != GBT_SYMBOL )
		goto type_missmatch;
	return get_symbol(sym->symbol.data);
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"GetTag"),
		list(	n_get_string("type missmatch"),
			0));
}
