/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"

XL_SEXP * xl_GetSize();


void
init_GetSize(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"GetSize"),
		get_func_prim(xl_GetSize,FO_APPLICATIVE,0,2,2));
}

int
get_size(XL_SEXP * g)
{
int _ret;
	switch ( get_type(g) ) {
	case GBT_NULL:
	case GBT_ERROR:
		_ret = 0;
		break;
	case GBT_PAIR:
		_ret = 0 ;
		for ( ; get_type(g) == GBT_PAIR ; g = cdr(g) )
			_ret += get_size(car(g));
		if ( get_type(g) != GBT_NULL )
			_ret += get_size(g);
		break;
	case GBT_SYMBOL:
		_ret = l_strlen(g->symbol.data);
		break;
	case GBT_STRING:
		_ret = l_strlen(g->string.data);
		break;
	case GBT_INTEGER:
		_ret = sizeof(g->integer.data);
		break;
	case GBT_FLOAT:
		_ret = sizeof(g->floating.data);
		break;
	case GBT_FUNC:
	case GBT_PTR:
		_ret = 0;
		break;
	case GBT_RAW:
		_ret = g->raw.size;
		break;
	case GBT_ENV:
		_ret = 0;
		break;
	default:
		er_panic("GetSize(1)");
	}
	return _ret;
}

XL_SEXP *
xl_GetSize(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * g;
int _ret;
	g = get_el(s,1);
	_ret = get_size(g);
	return get_integer(_ret,0);
}


