/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xl.h"
#include	"xlerror.h"

XL_SEXP * xl_GetPrefixMode();

void
init_GetPrefixMode(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"GetPrefixMode"),
		get_func_prim(xl_GetPrefixMode,FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
xl_GetPrefixMode(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * pref;
XL_GETFILE * gf;
XL_SEXP * ret;
XL_SEXP * cmd;
XL_GF_CMD * gfc;
	pref = get_el(s,1);
	if ( get_type(pref) != GBT_STRING )
		goto type_missmatch;
	gf = 0;
	ret = 0;
	for ( ; ; ) {
		gf = search_getfile_by_prefix(pref->string.data,gf);
		if ( gf == 0 )
			break;
		cmd = 0;
		for ( gfc = gf->cmd ; gfc ; gfc = gfc->next )
			cmd = cons(get_string(gfc->cmd),cmd);
		ret = cons(
			List(
				get_string(gf->prefix),
				get_string(gf->agent),
				get_string(gf->mode),
				get_integer(gf->flags,0),
				cmd,
				-1),
			ret);
	}
	return ret;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"GetPrefixMode"),
		n_get_string("type missmatch"));
}
