/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"


XL_SEXP * xl_GetChar();

void
init_GetChar(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"GetChar"),
		get_func_prim(xl_GetChar,FO_APPLICATIVE,0,3,3));
}

XL_SEXP *
xl_GetChar(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * str;
XL_SEXP * num;
L_CHAR * c;
int	len;
	str = get_el(s,1);
	num = get_el(s,2);
	if ( (get_type(str) != GBT_STRING) || (get_type(num) != GBT_INTEGER) ) {
		return get_error(
			s->h.file,
			s->h.line,
			XLE_SEMANTICS_TYPE_MISSMATCH,
			l_string(std_cm,"GetChar"),
			list(	n_get_string("index error in GetChar argument"),
				0));
	}
	c = str->string.data;
	len = l_strlen(str->string.data);
	if ( (num->integer.data < 0) || (num->integer.data > len) ) {
		return get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_INV_PARAM,
			l_string(std_cm,"GetChar"),
			list(	n_get_string("index error in GetChar argument"),
				0));
	}
	return get_integer(c[num->integer.data],0);
}
