/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/




#include	"xlerror.h"
#include	"xl.h"


XL_SEXP * xl_Eval();

void
init_Eval(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"Eval"),
		get_func_prim(xl_Eval,FO_APPLICATIVE,0,3,3));
}

XL_SEXP *
xl_Eval(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * e;
XL_SEXP * ss;
XL_SEXP * ret;
	e = get_el(s,1);
	ss = get_el(s,2);
	switch ( get_type(e) ) {
	case GBT_ERROR:
		return e;
	case GBT_ENV:
		break;
	default:
		goto type_missmatch;
	}
	if ( get_type(ss) == GBT_ERROR )
		return ss;
	ret = eval(e->env.data,ss);
	return ret;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"Eval"),
		n_get_string("type missmatch"));
}

