/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/




#include	"xlerror.h"
#include	"xl.h"


XL_SEXP * xl_CutOut();

void
init_CutOut(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"CutOut"),
		get_func_prim(xl_CutOut,FO_APPLICATIVE,0,4,4));
}

XL_SEXP *
xl_CutOut(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * s1;
XL_SEXP * s2;
XL_SEXP * ss;
XL_SEXP * r;
XL_SEXP * ret;
int i, i1, i2;
	ss = get_el(s,1);
	s1 = get_el(s,2);
	s2 = get_el(s,3);
	if ( (get_type(ss) != GBT_PAIR) || (get_type(s1) != GBT_INTEGER) || (get_type(s2) != GBT_INTEGER) )
		goto type_missmatch;

	i1 = s1->integer.data;
	i2 = s2->integer.data;
	if ( i1 > i2 ) {
		return get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_INV_PARAM,
			l_string(std_cm,"CutOut"),
			0);
	}

	for ( i = 0 ; (i < i1) && (get_type(ss) == GBT_PAIR) ; i ++, ss = cdr(ss) ) ;
	for ( r = 0 ; (i <= i2) && (get_type(ss) == GBT_PAIR) ; i ++, ss = cdr(ss) )
		r = cons(car(ss),r);
	for ( ret = 0 ; get_type(r) ; r = cdr(r) )
		ret = cons(car(r),ret);
/*
	set_inh(ret);
*/
	return ret;

type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"CutOut"),
		0);
}

