/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"memory_debug.h"
#include	"xlerror.h"
#include	"xl.h"
#include	"utils.h"

XL_SEXP * xl_CloseSession();

void
init_CloseSession(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"CloseSession"),
		get_func_prim(xl_CloseSession,FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
xl_CloseSession(XLISP_ENV * env,XL_SEXP * s)
{
int ret;
XL_SEXP * id;
int _id;
	id = get_el(s,1);
	if ( get_type(id) != GBT_INTEGER )
		return get_error(
			s->h.file,
			s->h.line,
			XLE_SEMANTICS_TYPE_MISSMATCH,
			l_string(std_cm,"CloseSession"),
			n_get_string(
			"id type missmatch"));
	close_session(id->integer.data);
	return 0;
}


