/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<errno.h>
#include	"xlerror.h"
#include	"xl.h"

XL_SEXP * xl_Chdir();


void
init_Chdir(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"Chdir"),
		get_func_prim(xl_Chdir,FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
xl_Chdir(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * path;
	path = get_el(s,1);
	if ( get_type(path) != GBT_STRING )
		goto type_missmatch;
	if ( chdir(n_string(std_cm,path->string.data)) < 0 ) {
	}
	return 0;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"Chdir"),
		0);
internal_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SYSTEM_INTERNAL,
		l_string(std_cm,"Chdir"),
		List(n_get_string("ERROR"),
			get_integer(errno,0),
			-1));
}


