/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/




#include	"xlerror.h"
#include	"xl.h"


XL_SEXP * xl_Append();

void
init_Append(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"Append"),
		get_func_prim(xl_Append,FO_APPLICATIVE,0,3,3));
}

XL_SEXP *
xl_Append(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * a;
XL_SEXP * b;
XL_SEXP * ss;
XL_SEXP * ret;
XL_SEXP * sym_a,* sym_b, * sym;
XL_SYM_FIELD * sf1,* sf2;
	a = get_el(s,1);
	b = get_el(s,2);
	if ( get_type(a) == GBT_NULL )
		return b;
	if ( get_type(b) == GBT_NULL )
		return a;
	if ( (get_type(a) != GBT_PAIR) || (get_type(b) != GBT_PAIR) )
		goto type_missmatch;

	sym_a = car(a);
	sym_b = car(b);
	ss = 0;
	for ( ; get_type(a) == GBT_PAIR ; a = cdr(a) )
		ss = cons(car(a),ss);
	if ( get_type(a) != 0 )
		goto type_missmatch;
	for ( ; get_type(b) == GBT_PAIR ; b = cdr(b) )
		ss = cons(car(b),ss);
	if ( get_type(b) != 0 )
		goto type_missmatch;
	ret = 0;
	for ( ; get_type(ss) ; ss = cdr(ss) )
		ret = cons(car(ss),ret);
	if( get_type(sym_a) == GBT_SYMBOL &&
			get_type(sym_b) == GBT_SYMBOL ) {
		sym = get_symbol(sym_a->symbol.data);
		sf2 = sym_a->symbol.field;
		for ( sf1 = sym_b->symbol.field;
				sf1;
				sf1 = sf1->next ) {
			sf2 = set_sym_field(sf2,sf1->name,sf1->data);
		}
		sym->symbol.field = sf2;
		ret = cons(sym,cdr(ret));
	}
/*
	set_inh(ret);
*/
	return ret;

type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"Append"),
		0);
}


