/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"memory_debug.h"
#include	"xl.h"
#include	"xl2pdb_p.h"
#include	"unit.h"
#include	"utils.h"

L_CHAR * unitname;
extern GB_RECT minrect;
int point_nos;

XL_SEXP * xl_point();

void
init_point(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"point"),
		get_func_prim(xl_point,FO_APPLICATIVE,0,2,3));
}


void
get_lod(int * min,int * max,L_CHAR * data)
{
char * d;
char * dd;
	d = n_string(std_cm,data);
	for ( dd = d ; *dd ; dd++ )
		if ( *dd == '-' ) {
			*dd = 0;
			dd++;
		}
	if ( *dd == 0 ) {
		sscanf(d,"%i",min);
		*max = *min;
	}
	else {
		sscanf(d,"%i",min);
		sscanf(dd,"%i",max);
	}
}


XL_SEXP *
xl_point(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf)
{
PDB_POLYGON2D * p;
XL_SEXP * ret;
PDB_PD_POINT * ptr, ** ptrp;
int len,len2;
XL_SEXP * x,* y, * lst;
GB_POINT _ptr;
char * e_param;
int no;
int lod_max,lod_min;
int er;


	p = get_polygon(&ret,sf,s->h.file,s->h.line);
	if ( p == 0 )
		return ret;
	no = -1;
	lod_min = lod_max = 0;
	for ( ; sf ; sf = sf->next ) {
		if ( l_strcmp(sf->name,l_string(std_cm,"no")) == 0 )
			sscanf(n_string(std_cm,sf->data),"%i",&no);
		else if ( l_strcmp(sf->name,l_string(std_cm,"lod"))
				== 0 ) {
			get_lod(&lod_min,&lod_max,sf->data);
		}
		else if ( l_strcmp(sf->name,l_string(std_cm,"name")) &&
			l_strcmp(sf->name,l_string(std_cm,"subname")) ) {
			e_param = n_string(std_cm,sf->name);
			goto unknown_attribute;
		}
	}
	len = list_length(s);
	if ( len != 2 && len != 3 )
		goto list_length_error;
	if ( len == 2 ) {
		lst = get_el(s,1);
		if ( get_type(lst) != GBT_PAIR ) {
			e_param = "1st";
			goto type_missmatch;
		}
		x = get_el(lst,0);
		y = get_el(lst,1);
	}
	else {
		x = get_el(s,1);
		y = get_el(s,2);
	}
	switch ( get_type(x) ) {
	case GBT_INTEGER:
		_ptr.x = conv_unit(&er,
			x->integer.data,
			x->integer.unit,
			unitname);
		break;
	case GBT_FLOAT:
		_ptr.x = conv_unit(&er,
			x->floating.data,
			x->floating.unit,
			unitname);
		break;
	default:
		e_param = "x coordinate";
		goto type_missmatch;
	}
	switch ( get_type(y) ) {
	case GBT_INTEGER:
		_ptr.y = conv_unit(
			&er,
			y->integer.data,
			y->integer.unit,
			unitname);
		break;
	case GBT_FLOAT:
		_ptr.y = conv_unit(
			&er,
			y->floating.data,
			y->floating.unit,
			unitname);
		break;
	default:
		e_param = "y coordinate";
		goto type_missmatch;
	}
	ptr = d_alloc(sizeof(*ptr),545);
	ptr->reso = -1;
	ptr->no = no;
	ptr->lod_max = lod_max;
	ptr->lod_min = lod_min;
	ptr->p = _ptr;
	for ( ptrp = &p->point ; *ptrp ; ptrp = &(*ptrp)->next ) {
		if ( (*ptrp)->no + 1 == ptr->no &&
			(*ptrp)->p.x == ptr->p.x &&
			(*ptrp)->p.y == ptr->p.y ) {
				d_f_ree(ptr);
				goto end;
		}
		if ( (*ptrp)->no < ptr->no )
			break;
	}
	ptr->next = *ptrp;
	*ptrp = ptr;
	point_nos ++;
	insert_rect(&p->minrect,_ptr);
	insert_rect(&minrect,_ptr);
end:
	return 0;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"point"),
			List(n_get_string("type missmatch"),
				n_get_string(e_param),
				-1));
list_length_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_INV_PARAM_LENGTH,
		l_string(std_cm,"point"),
			List(n_get_string("invalid parameter length"),
				-1));
unknown_attribute:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"color cmd"),
			List(n_get_string("unknown attribute"),
				n_get_string(e_param),
				-1));
}
