/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"gbgraph.h"
#include	"xlerror.h"
#include	"xl.h"

extern void gc_gb_sexp();
XL_SEXP * xl_MinimumRectangle();
int loading_target;

void
init_MinimumRectangle(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"MinimumRectangle"),
		get_func_prim(xl_MinimumRectangle,FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
xl_MinimumRectangle(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * ptr;
GB_RECT r;
XL_SEXP * p;
XL_SEXP * xx;
GB_POINT pt;
	ptr = get_el(s,1);
	r.tl.x = r.tl.y = 0;
	r.br.x = r.br.y = -1;
	for ( ; get_type(ptr) == GBT_PAIR ; ptr = cdr(ptr) ) {
		p = car(ptr);
		switch ( list_length(p) ) {
		case 2:
			break;
		case -1:
			return list_error(p);
		default:
			goto type_missmatch;
		}
		xx = get_el(p,0);
		switch ( get_type(xx) ) {
		case GBT_INTEGER:
			pt.x = xx->integer.data;
			break;
		case GBT_FLOAT:
			pt.x = xx->floating.data;
			break;
		default:
			goto type_missmatch;
		}
		xx = get_el(p,1);
		switch ( get_type(xx) ) {
		case GBT_INTEGER:
			pt.y = xx->integer.data;
			break;
		case GBT_FLOAT:
			pt.y = xx->floating.data;
			break;
		default:
			goto type_missmatch;
		}
		insert_rect(&r,pt);
	}
	return List(
		List(	get_floating(r.tl.x,0),
			get_floating(r.tl.y,0),
			-1),
		List(	get_floating(r.br.x,0),
			get_floating(r.br.y,0),
			-1),
		-1);
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"MinimumRectangle"),
		List(n_get_string("type_missmatch"),
			-1));
}
