/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<fcntl.h>
#include	"xlerror.h"
#include	"xl.h"
#include	"netmapper.h"

extern void gc_gb_sexp();
XL_SEXP * xl_LoadingTarget();
int loading_target;
int backup_fid;

void
init_LoadingTarget(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"LoadingTarget"),
		get_func_prim(xl_LoadingTarget,FO_NORMAL,0,2,-1));
}


void
load_backup(int fid)
{
BACKUP_HEADER h;
int type;
int er;
NM_VERTEX * prev_v, * v;
NAME_PTR ptr;
int path;
	read(fid,&h,sizeof(&h));
	prev_v = 0;
	path = 0;
	for ( ; ; ) {
		er = read(fid,&type,sizeof(type));
		if ( er <= 0 )
			break;
		switch ( type ) {
		case BT_EDGE:
			prev_v = 0;
			break;
		case BT_VERTEX:
			read(fid,&ptr,sizeof(ptr));
			v = new_vertex(&net_target[loading_target-1],
				&ptr,sizeof(ptr));
			if ( prev_v )
				new_edge(&net_target[loading_target-1],
					prev_v,v);
			prev_v = v;
			break;
		default:
			er_panic("load_backup");
		}
	}
}

XL_SEXP *
xl_LoadingTarget(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf)
{
int target;
XL_SEXP * ret;
int name_type;
L_CHAR * backup;
	target = 0;
	name_type = NMT_PTR;
	backup = 0;
	for ( ; sf ; sf = sf->next ) {
		if ( l_strcmp(sf->name,l_string(std_cm,"target")) == 0 ) {
			target = atoi(n_string(std_cm,sf->data));
		}
		else if ( l_strcmp(sf->name,l_string(std_cm,"type")) == 0 ) {
			if ( l_strcmp(sf->data,l_string(std_cm,"svg")) == 0 ) {
				name_type = NMT_PTR;
			}
			else {
				goto invalid_param;
			}
		}
		else if ( l_strcmp(sf->name,l_string(std_cm,"backup")) == 0 ) {
			backup = sf->data;
		}
	}
	if ( target == 0 )
		goto invalid_param;
	init_target(&net_target[target-1],name_type);
	loading_target = target;
	if ( backup ) {
	int fid;
		fid = open(n_string(std_cm,backup),O_RDONLY);
		if ( fid < 0 )
			goto xl;
		load_backup(fid);
		close(fid);
		ret = 0;
		goto end;
	}
xl:
	if ( backup ) {
	BACKUP_HEADER h;
		backup_fid = open(n_string(std_cm,backup),
			O_RDWR|O_CREAT|O_TRUNC,0644);
		h.type = NMT_PTR;
		write(backup_fid,&h,sizeof(h));
	}
	else	backup_fid = -1;
	for ( s = cdr(s) ; get_type(s) == GBT_PAIR ; s = cdr(s) ) {
		gc_push(0,0,"LoadingTarget");
		ret = eval(env,car(s));
		gc_pop(ret,gc_gb_sexp);
		if ( get_type(ret) == GBT_ERROR )
			break;
	}
	close(backup_fid);
	backup_fid = -1;
end:
	printf("\n");
	clean_ve(&net_target[loading_target-1]);
	loading_target = 0;
	return ret;
invalid_param:

	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"LoadingTarget"),
		0);
}


