/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"
#include	"kyotodb.h"
#include	"favt.h"
#include	"dtree.h"

extern L_CHAR cutpattern[100][10];
XL_SEXP * xl_set_tword();

void
init_set_tword(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"set-tword"),
		get_func_prim(xl_set_tword,FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
xl_set_tword(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * lst;
XL_SEXP * pp, * tt;
XL_SEXP * word, * direct;
	lst = get_el(s,1);
	if ( get_type(lst) != GBT_PAIR )
		goto type_missmatch;
	for ( pp = lst ; get_type(pp) == GBT_PAIR ; pp = cdr(pp) ) {
		tt = car(pp);
		if ( list_length(tt) < 2 )
			goto type_missmatch;
		word = get_el(tt,0);
		direct = get_el(tt,1);
		if ( get_type(word) != GBT_STRING )
			goto type_missmatch;
		if ( get_type(direct) != GBT_STRING )
			goto type_missmatch;
		set_tword(word->string.data,direct->string.data);
	}
	return 0;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"set-tword"),
		0);

}


