/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include "kibandata.h"

#define PNT_TYPE_EKI		1
#define PNT_TYPE_KIJUNTEN	2

/* 쥳 */
typedef struct pnt_record{
	char code[32];
	/* ֹ */
	int id;
	GB_POINT pt;
} PNT_RECORD;

/* °եΥǡ */
typedef struct pnt_data{
	KIBAN_FILE_HEADER header;
	PNT_RECORD *record;
} PNT_DATA;

/* °ǡɤ߹ */
int ReadPnt(const char *filename, FILE *fp, PNT_DATA *pPnt, int Flags);
int Pnt2SVG(FILE *fp, PNT_DATA *pPnt, int nType, const char *szFillColor, const char *szStrokeColor);

PNT_DATA *malloc_pnt_data();
void free_pnt_data(PNT_DATA *pData);
