/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___GBF_H___
#define ___GBF_H___


#include "v.h"

typedef struct gbf_header {
	char		signature[16];
	char		fontname[224];
	int		size;
	int		st_no;
	int		end_no;	
	int		nos;
} GBF_HEADER;

typedef struct gbf_ofs {
	short		st_x;
	short		st_y;
	short		end_x;
	short		end_y;
	short		w;
	short		type;
#define FT_SPACE 0 /* white space */
#define FT_BITMAP 1 /* 1 bit */
#define FT_GRAY 2 /* 8 bit grayscale */
	unsigned int	ofs;
} GBF_OFS;

typedef struct gbf_data {
	struct gbf_data *	next;
	GBF_OFS * ofs;
	char		path[1000];
	short		id;

	int		st_no;
	int		end_no;	
	int		nos;
} GBF_DATA;


void gbf_init();
void gbf_set_display_key(char * key);
GBF_DATA * gbf_search(short id);
unsigned int gbf_get_len(GBF_OFS * ofs);

VDISPLAY * gbf_open_disp(VERROR * err);

void gbf_get_string_pic(
	V_STRING_PIC * p,
	VDISPLAY * disp,
	L_CHAR * str,
	int	size,
	int 	dir);


#endif