/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef ___HTMLDB_H___
#define ___HTMLDB_H___

#include "xllisp.h"
#include	"http.h"



extern XL_SEXP* HTMLDataBase;	//$B%G!<%?%Y!<%9K\BN$X$N%]%$%s%?(B
extern XL_SEXP* CurrentPage;	//$B8=:_I=<($7$F$$$k%G!<%?(B
extern L_CHAR CurrentURL[1024];//$B8=:_I=<($7$F$$$k(BURL

extern XL_SEXP* PrimitiveFunctions;

typedef enum HTMLFileType{html,cgi,other}HTMLFileType;
typedef enum UpdateOption{force,immediate,regist,non}UpdateOption;
typedef enum ElementType{HTMLDoc,XLScript,Raw,Primitive}ElementType;
typedef enum EvalType{EvalOn,EvalOff}EvalType;

XL_SEXP* exec_option(L_CHAR*,XL_SEXP*,L_CHAR*,XL_FILE*,int);

L_CHAR* GetOption(L_CHAR*,XL_SYM_FIELD *);	//$B%?%0Fb$N%*%W%7%g%s$r<h$C$F$/$k(B
HTMLFileType CheckFileType(L_CHAR *);		//GetOption$B$G<h$C$F$-$?%*%W%7%g%s$r%A%'%C%/$9$k(B
UpdateOption CheckUpdateOption(L_CHAR *);	//$BF1>e(B
EvalType CheckEvalType(L_CHAR *);		//$BF1>e(B
XL_SEXP* MakeURLList(L_CHAR*,XLISP_ENV *);	//URL$BJ8;zNs$+$i(B/$B$GJ,3d$7$?%j%9%H$r:n$k(B


XL_SEXP* RemoveElement(L_CHAR*,XL_SEXP*);	//url$BJ8;zNs$r;}$D%G!<%?$r>C5n(B
XL_SEXP* GetElement(L_CHAR*,XL_SEXP*);		//URL$BJ8;zNs$G%G!<%?%Y!<%9Fb$r8!:w(B
XL_SEXP* IsExist(L_CHAR*,XL_SEXP*);		//$B%G!<%?%Y!<%9Fb$KF1$8(Burl$B$N%G!<%?$,B8:_$9$k$+%A%'%C%/(B

ElementType CheckElementType(XL_SEXP*);		//$BMWAG$,(BHTML,XLScript,Primitive$B$N$I$l$+$rH=JL(B
L_CHAR* GetURLString(XL_SEXP*);			//$BMWAG$N(BURL$B$rJ8;zNs$H$7$F<h$C$F$/$k(B
int CheckWildCard(L_CHAR*);			//URL$BJ8;zNs$K(B*$B$,F~$C$F$$$k$+$I$&$+$r3N$+$a$k(B
XL_SEXP* GetDocument(XL_SEXP*);			//HTML$BJ8=q$r<h$C$F$/$k(B
XL_SEXP* GetScript(XL_SEXP*);			//XLScript$B$r<h$C$F$/$k(B
void* GetFunction(XL_SEXP*);			//$B4X?t$X$N%]%$%s%?$r<h$C$F$/$k(B
L_CHAR* GetKey(XL_SEXP*);			//key$BJ8;zNs$r<h$C$F$/$k(B


//$B%Z!<%8I=<($J$I(B
void SetCurrentPage(L_CHAR*,XL_SEXP*);		//$BI=<($9$k%Z!<%8$N(BURL$B$r%;%C%H$9$k(B
void PutCurrentPage();				//$B%Z!<%8$rI=<($9$k(B
void ExecScript(XL_SEXP*);			//$B%9%/%j%W%H<B9T(B
int ExecPrimitive(STREAM*,XL_SEXP*);		//$B%W%j%_%F%#%V<B9T(B

extern SEM html_db_lock;
void init_html_db();
/* mori
XLISP_ENV* dbENV;
*/


#endif
