/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include "xl.h"
#include "gbview.h"
#include "xlerror.h"

XL_SEXP * xl_gv_flame_set_status();

void
init_gv_flame_set_status(XLISP_ENV * env)
{
	set_env(env, l_string(std_cm,"gv-flame-set-status"),
			get_func_prim(xl_gv_flame_set_status,FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
xl_gv_flame_set_status(
		XLISP_ENV * e,
		XL_SEXP * s)
{
XL_SEXP *status_list, *header, *status, *data;
GBVIEW_STATUS gs;
int seq;
char change = 0;
	
	if ( list2gvstatus(get_el(s,1),&gs) < 0)
		goto param_error;
	
printf("SET_STATUS ");
if ( gs.flags & SF_WIDTH )
printf("width %d ",gs.width);
if ( gs.flags & SF_HEIGHT )
printf("height %d ",gs.height);
printf("\n");
	
	seq = wf_set_status(&gs);
	return get_integer(seq,0);


type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"gv-flame-set-status"),
		List(n_get_string("type missmatch"),
			-1));
param_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"gv-flame-set-status"),
		List(n_get_string("invalid status list"),
			-1));
}
