/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include <fcntl.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include	"machine/include.h"
#include	"memory_debug.h"
#include	"xl.h"
#include	"xldir.h"
#include	"mp.h"
#include	"gbmp.h"
#include	"lock_level.h"
#include	"lump.h"
#include	"acrp.h"

extern int max_hops;


typedef struct around_list {
	struct around_list *	next;
	L_CHAR *		url;
} AROUND_LIST;

extern L_CHAR * sys_path;
SEM	lump_lock;

void
init_lump()
{
	lump_lock = new_lock(LL_LUMP);
}


char *
make_base_dir()
{
char * path;
int len;
	path = ln_copy_str(std_cm,sys_path);
	len = strlen(path);
	path = d_re_alloc(path,len + 100);
	strcpy(&path[len],"/work");
	u_mkdir(path,0755);
	len = strlen(path);
	strcpy(&path[len],"/lump");
	u_mkdir(path,0755);

	return path;
}


void
make_lump_dir(unsigned int id)
{
int i;
char * path;
int len;
	path = make_base_dir();
	len = strlen(path);
	for ( i = 0 ; i < 4 ; i ++ ) {
		sprintf(&path[len],"/%i",(id>>(8*(3-i)))&0x0ff);
		u_mkdir(path,0755);
		len = strlen(path);
	}
}


char *
n_get_lump_path(unsigned int id)
{
char * path;
int len;
char * ret;
	path = copy_str("/work/lump");
	len = strlen(path);
	path = d_re_alloc(path,len + 100);
	sprintf(&path[len],"/%i/%i/%i/%i/",
		(id >> 24) & 0x0ff,
		(id >> 16) & 0x0ff,
		(id >> 8) & 0x0ff,
		id & 0x0ff);
	return path;
}

L_CHAR *
get_lump_path(unsigned int id)
{
char * path;
L_CHAR * ret;
	path = n_get_lump_path(id);
	ret = nl_copy_str(std_cm,path);
	d_f_ree(path);
	return ret;
}

int
check_dir(unsigned int id)
{
STREAM * s;
char * _path;
char * path;
	_path = n_get_lump_path(id);
	path = ln_copy_str(std_cm,sys_path);
	path = d_re_alloc(path,strlen(path)+strlen(_path)+10);
	strcpy(&path[strlen(path)],_path);
	s = s_open_file(path,O_RDONLY);
	d_f_ree(_path);	
	d_f_ree(path);
	if ( s == 0 )
		return 0;
	s_close(s);
	return -1;
}


unsigned int
new_lump()
{
extern L_CHAR * sys_path;
unsigned int	id;
MP_WORK mpw;

	get_mp_work(&mpw,0);

	lock_task(lump_lock);
	id = mpw.lump_id;
	for ( ; check_dir(id) ; id ++ );
	make_lump_dir(id);
	mpw.lump_id = id + 1;
	unlock_task(lump_lock,"new_lump");

	set_mp_work(&mpw);
	return id;
}


int
check_lump_path(int ses,char * path)
{
L_CHAR * _path;
L_CHAR * ptr;
int cnt;
LUMP_INFO info;
LUMP_OPT opt;
XL_SEXP * lump;
URL u;
int ret;
int len;
XL_SEXP * remote_fetch_lump();


	_path = nl_copy_str(std_cm,path);
	len = l_strlen(_path);
	_path = d_re_alloc(_path,(len+10)*sizeof(L_CHAR));
	_path[len] = '/';
	_path[len+1] = 0;
	ptr = &_path[len+1];
	for ( cnt = 7 ; cnt > 0 ; cnt -- ) {
		ptr --;	
		for ( ; *ptr != '/' ; ptr -- );
	}
	if ( load_lump_info(&info,ptr) < 0 ) {
		ret = -1;
		goto end0;
	}

	gc_push(0,0,"check_lump_path");

	get_url2(&u,info.crd,1234);
	lump = remote_fetch_lump(ses,&u);
	if ( lump == 0 ) {
		ret = -1;
		goto end;
	}
	lump = get_el_by_symbol(lump,
		l_string(std_cm,"option"),
		0);
	if ( get_type(lump) == GBT_NULL ) {
		ret = -1;
		goto end;
	}
	init_lump_opt(&opt);
	lr_option(&opt,lump);
	if ( opt.lump == 0 ) {
		ret = -1;
		goto end1;
	}
	ptr[l_strlen(opt.lump)] = 0;
	if ( l_strcmp(ptr,opt.lump) ) {
		ret = -1;
		goto end1;
	}
	ret = 0;
end1:
	free_lump_opt(&opt);
end:
	gc_pop(0,0);
	free_lump_info(&info);
end0:
	d_f_ree(_path);
	return ret;
}


void
rm_lump_path(char * path)
{
char * p;
char * ptr;
int cnt;
int flag;
	p = copy_str(path);
	flag = RMF_REC|RMF_DIR|RMF_FILE;
	ptr = &p[strlen(p)];
	for ( cnt = 4 ; cnt > 0 ; cnt -- ) {
		u_rm(p,flag);
		flag = RMF_DIR|RMF_FILE;
		ptr --;
		for ( ; *ptr != '/' ; ptr -- );
		ptr[1] = 0;
	}
	d_f_ree(p);
}

void
lump_gc_path(int ses)
{
char * path;
int len;
DIR_LIST * d, * d1, * d2;
	path = ln_copy_str(std_cm,sys_path);
	len = strlen(path);
	path = d_re_alloc(path,len + 100);
	strcpy(&path[len],"/work/lump/*/*/*/*");
	d = get_dir(path,0,0,0,
		DLF_DIR|DLF_T_EXIST_D|DLF_T_STAMP_D);
	d_f_ree(path);
	for ( d1 = d ; d1 ; d1 = d1->next ) {
printf("-- %s\n",d1->name);
		if ( check_lump_path(ses,d1->name) == 0 )
			continue;
printf("flush\n");
		rm_lump_path(d1->name);
	}
	free_dir_list(d);
}

AROUND_LIST *
get_around_list(AROUND_LIST * a,XL_SEXP * p,char * dir)
{
L_CHAR * _dir;
XL_SEXP * rec, * el, * sym,* dt;
AROUND_LIST * al1;
	_dir = l_string(std_cm,dir);
	for ( ; get_type(p) == GBT_PAIR  ; p = cdr(p) ) {
		rec = car(p);
		if ( get_type(rec) != GBT_PAIR )
			continue;
		for ( ; get_type(rec) == GBT_PAIR ; rec = cdr(rec) ) {
			el = car(rec);
			if ( get_type(el) != GBT_PAIR )
				continue;
			sym = car(el);
			if ( get_type(sym) != GBT_SYMBOL )
				continue;
			if ( l_strcmp(sym->symbol.data,_dir) )
				continue;
			dt = get_el(el,1);
			if ( get_type(dt) != GBT_STRING )
				continue;
			al1 = d_alloc(sizeof(*al1),123);
			al1->url = ll_copy_str(dt->string.data,1391);
			al1->next = a;
			a = al1;
		}
	}
	return a;
}

void
print_around_list(AROUND_LIST * a)
{
	for ( ; a ; a = a->next ) {
		printf(" %s",n_string(std_cm,a->url));
	}
	printf("\n");
}

void
free_around_list2(AROUND_LIST * a)
{
AROUND_LIST * a1;
	for ( ; a ; ) {
		a1 = a->next;
		d_f_ree(a->url);
		d_f_ree(a);
		a = a1;
	}
}


XL_SEXP * 
remote_fetch_lump(int ses,URL * u)
{
XL_SEXP * ret;
XL_SEXP * gt;
L_CHAR * f;
void gc_gb_sexp();


	gc_push(0,0,"remote_fetch");
	gt = get_symbol(l_string(std_cm,"Get"));
	set_attribute(gt,
		l_string(std_cm,"mode"),
		l_string(std_cm,"lump"));

	f = get_url_filepath(u);

	ret = remote_session(
		gblisp_top_env0,
		ses,
		u,
		l_string(std_cm,"gbstd"),
		l_string(std_cm,"user"),
		l_string(std_cm,"Get"),
		List(List(gt,
			get_string(f),
			-1),
			-1),
		0,0,0);
	d_f_ree(f);

	if ( get_type(ret) != GBT_PAIR )
		ret = 0;
	gc_pop(ret,gc_gb_sexp);
	return ret;
}



LUMP_ROUTE *
compose_lr(URL * u,LUMP_ROUTE * lr1,LUMP_ROUTE * lr2,L_CHAR * comein)
{
LUMP_ROUTE * lr3, * lr4, * lr5;
URL uu;
	for ( lr3 = lr2 ; lr3 ; lr3 = lr3->next ) {
		get_url2(&uu,lr3->dir,1239);
		if ( url_cmp(u,&uu) == 0 ) {
			free_url(&uu);
			continue;
		}
		free_url(&uu);
		lr4 = search_lr(lr1,lr3->lump_crd);
		if ( lr4 ) {
			if ( lr3->distance + 1 < lr4->distance ) {
				lr4->distance = lr3->distance + 1;
				if ( lr4->dir )
					d_f_ree(lr4->dir);
				lr4->dir = ll_copy_str(comein,1390);
			}
		}
		else {
			lr1 = insert_lr(lr1,lr3,1,comein);
		}
	}
	return lr1;
}




int
cmp_lr(LUMP_ROUTE * lr1,LUMP_ROUTE * lr2)
{
	for ( ; lr1 && lr2 ; lr1 = lr1->next , lr2 = lr2->next ) {
		if ( l_strcmp(lr1->lump_crd,lr2->lump_crd) )
			return -1;
		if ( l_strcmp(lr1->dir,lr2->dir) )
			return -1;
		if ( lr1->pri != lr2->pri )
			return -1;
		if ( lr1->distance != lr2->distance )
			return -1;
	}
	if ( lr1 == 0 && lr2 == 0 )
		return 0;
	return -1;
}

void
get_my_url(URL * u,L_CHAR * url_str)
{
static int local_ip;
int p;

	if ( local_ip == 0 )
		local_ip = get_localhostip();

	p = get_my_port();
	get_url2(u,url_str,1240);
	if ( u->proto == 0 )
		u->proto = nl_copy_str(std_cm,"xlp");
	if ( u->server == 0 )
		u->server = ll_copy_str(gblisp_site,1389);
	if ( u->port == 0 )
		u->port = p;
	if ( u->db[0] != '/' ) {
	L_CHAR * buf;
	int len;
		len = l_strlen(u->db);
		buf = d_alloc(sizeof(L_CHAR)*(len+2),23);
		l_strcpy(&buf[1],u->db);
		buf[0] = '/';
		d_f_ree(u->db);
		u->db = buf;
	}
}

XL_SEXP *
fileimage_of_lr(LUMP_OPT * opt,LUMP_ROUTE * lr)
{
XL_SEXP * ret;
XL_SEXP * option;

	ret = 0;
	option = 0;
	for ( ; lr ; lr = lr->next ) {
		ret = cons(
			List(n_get_symbol("entry"),
				get_string(lr->lump_crd),
				get_string(lr->dir),
				get_integer(lr->pri,0),
				get_integer(lr->distance,0),
				get_integer(lr->radius,0),
				-1),
			ret);
	}
	if ( opt ) {
		if ( opt->destroy ) {
			option = cons(
				List(n_get_symbol("destroy"),
					get_integer(opt->destroy,0),
					-1),
				option);
		}
		if ( opt->launch ) {
			option = cons(
				List(n_get_symbol("launch"),
					get_integer(opt->launch,0),
					-1),
				option);
		}
		if ( opt->lump ) {
			option = cons(
				List(n_get_symbol("lump"),
					get_string(opt->lump),
					-1),
				option);
		}
		if ( opt->fade_time ) {
			option = cons(
				List(n_get_symbol("fade"),
					get_integer(opt->fade_time,0),
					get_integer(opt->fade_interval,0),
					-1),
				option);
		}
	}
	if ( option )
		ret = cons(cons(n_get_symbol("option"),option),ret);
	ret = cons(n_get_symbol("lump-info"),ret);
	return ret;
}

void
save_lr(URL * u,LUMP_ROUTE * lr,LUMP_OPT * opt)
{
XL_SEXP * gt;
L_CHAR * filename;
STREAM * st;
int len;

	gc_push(0,0,"save_lr");
	gt = n_get_symbol("?xl");
	set_attribute(gt,
		l_string(std_cm,"version"),
		l_string(std_cm,"0.1"));
	set_attribute(gt,
		l_string(std_cm,"encoding"),
		l_string(std_cm,"EUC-JP"));
	filename = get_access_path(u,".lmp");
	st = s_open_file(
		n_string(std_cm,filename),
		O_CREAT|O_TRUNC|O_RDWR,
		0644);
	if ( st == 0 ) {
		d_f_ree(filename);
		gc_pop(0,0);
		return;
	}
	print_sexp(
		st,
		List(	List(gt,-1),
			fileimage_of_lr(opt,lr),
			-1),
		PF_MULTI_ROOT|PF_INDENT);
	s_printf(st,"\n");
	s_close(st);
	d_f_ree(filename);
	gc_pop(0,0);
}

LUMP_ROUTE *
filter_lr(LUMP_ROUTE * lr)
{
int cnt;
LUMP_ROUTE ** lrp, * lr1;

	for ( lrp = &lr ; *lrp ; ) {
		lr1 = *lrp;
		if ( lr1->radius <= lr1->distance ) {
			*lrp = lr1->next;
			free_lr(lr1);
		}
		else {
			lrp = &lr1->next;
		}
	} 
	cnt = 0;
	for ( lrp = &lr ; *lrp ; lrp = &(*lrp)->next , cnt ++ ) {
		if ( cnt >= LUMP_MAX )
			break;
	}
	for ( ; *lrp ; ) {
		lr1 = *lrp;
		*lrp = lr1->next;
		lr1->next = 0;
		free_lr(lr1);
	}
	return lr;
}

void
_trigger_lr(int ses,L_CHAR * url)
{
URL u;
int p;
int local_ip;
L_CHAR * path;
XL_SEXP * gt;
	p = get_my_port();
	local_ip = get_localhostip();
	get_url2(&u,url,1241);
	if ( u.server == 0 && u.port == 0 ) {
		u.port = p;
	}
	path = get_url_filepath(&u);
	if ( cmp_site(u.server,0,u.port,
			0,local_ip,p) == 0 ) {
		insert_tick_que(0,path,TQT_LMP,TQL_LUMP);
	}
	else {

		gc_push(0,0,"remote_fetch");

		gt = n_get_symbol("MPTrigger");
		set_attribute(gt,
			l_string(std_cm,"mode"),
			l_string(std_cm,"lump"));

		remote_session(
			gblisp_top_env0,
			ses,
			&u,
			l_string(std_cm,"gbstd"),
			l_string(std_cm,"user"),
			l_string(std_cm,"Get"),
			List(List(gt,
				get_string(path),
				-1),
				-1),
			0,0,1);

		gc_pop(0,0);
	}
	free_url(&u);
	d_f_ree(path);
}

void
trigger_lr(int ses,AROUND_LIST * a)
{
	for ( ; a ; a = a->next )
		_trigger_lr(ses,a->url);
}

LUMP_ROUTE *
get_dist0(LUMP_ROUTE * lr)
{
LUMP_ROUTE * ret;
	ret = 0;
	for ( ; lr ; lr = lr->next ) {
		if ( lr->distance )
			break;
		ret = insert_lr(ret,lr,0,0);
	}
	return ret;
}

LUMP_ROUTE *
set_dist0(LUMP_ROUTE * lr,URL * u)
{
LUMP_ROUTE lr0;
	lr0.lump_crd = get_url_str2(u);
	lr0.dir = l_string(std_cm,"");
	lr0.pri = get_xltime();
	lr0.distance = 0;
	lr0.radius = DEFAULT_TTL-1;
	return insert_lr(lr,&lr0,0,0);
}

int
check_launch(LUMP_ROUTE * lr,URL * me)
{
int ret;
int no_est_cnt;
URL u;
int same,other;
LUMP_ROUTE * lrp;

	same = 0;
	other = 0;
	for ( lrp = lr ; lrp ; lrp = lrp->next ) {
		get_url2(&u,lrp->lump_crd,1242);
		if ( l_strcmp(u.server,me->server) == 0 &&
				u.port == me->port )
			same ++;
		else	other ++;
		free_url(&u);
	}
	if ( same <= 1 && other == 0 )
		return 1;
	if ( same == 0 )
		return 1;
	return 0;
}



int
destroy_check(LUMP_ROUTE * lr)
{
LUMP_ROUTE * lr0;
URL me;
int ret;
URL u;
int same,other;


	if ( lr == 0 )
		return 0;
	if ( lr->distance )
		return 0;

	lr0 = lr;
	lr = lr->next;

	get_url2(&me,lr0->lump_crd,1243);

	same = 0;
	other = 0;
	for ( ; lr ; lr = lr->next ) {
		get_url2(&u,lr->lump_crd,1244);
		if ( l_strcmp(u.server,me.server) == 0 &&
				u.port == me.port ) {
			if ( lr->pri <= lr0->pri )
				same ++;
		}
		else	other ++;
		free_url(&u);
	}
	free_url(&me);

	if ( same <= 1 && other == 0 )
		return 0;
	if ( same == 0 )
		return 0;
	return 1;





	if ( check_launch(lr,&me) )
		ret = 0;
	else	ret = 1;
	free_url(&me);
	return ret;
}

int
check_loop_lump(LUMP_ROUTE ** lr)
{
int ret;
LUMP_ROUTE ** lrp;
LUMP_ROUTE * lr1;

	ret = 0;
	for ( lrp = lr ; *lrp ; ) {
		lr1 = *lrp;
		if ( max_hops && lr1->distance > max_hops ||
				check_loop_max(lr1->distance) < 0 ) {
printf("cut lump %i\n",max_hops);
			ret = 1;
			*lrp = lr1->next;
			lr1->next = 0;
			free_lr(lr1);
		}
		else {
			lrp = &lr1->next;
		}
	}
	return ret;
}

void
check_my_lump(int ses,L_CHAR * filename)
{
XL_SEXP * chi, * par;
AROUND_LIST * a, * a1;
URL u1,u2;
XL_SEXP * ret;
LUMP_ROUTE * lr, * lr1, * my_lr,* lr0;
LUMP_OPT opt;
char * path;
int len,slen;
int fd;
L_CHAR * cc;
int loop_ditect;
unsigned int now;

	init_lump_opt(&opt);
	gc_push(0,0,"check_my_kump make_list");
	chi = filtering_crd(get_crd_chi(filename));
	a = get_around_list(0,chi,"src");
	par = filtering_crd(get_crd_par(filename));
	a = get_around_list(a,par,"dest");

	get_my_url(&u1,filename);

	cc = ll_copy_str(get_url_str2(&u1),1388);
	ret = local_fetch(0,&u1,".lmp");
	my_lr = get_lr(&opt,ret,cc);
	d_f_ree(cc);

	gc_pop(0,0);

	lr = get_dist0(my_lr);
	for ( a1 = a ; a1 ; a1 = a1->next ) {
		get_url2(&u2,a1->url,1245);
		gc_push(0,0,"check_my_lump");
		if ( l_strcmp(u2.server,u1.server) == 0 &&
				u2.port == u1.port )
			ret = local_fetch(0,&u2,".lmp");
		else	ret = remote_fetch_lump(ses,&u2);
		lr1 = get_lr(0,ret,0);
		lr = compose_lr(&u1,lr,lr1,a1->url);
		free_lr(lr1);
		gc_pop(0,0);
		free_url(&u2);
	}

	if ( lr == 0 || lr->distance && check_launch(lr,&u1) ) {
		if ( opt.launch == 0 ) {
			opt.launch = get_xltime() + 
				LUMP_LAUNCH_MIN + 
				(rand()%
				(LUMP_LAUNCH_MAX-LUMP_LAUNCH_MIN));
			opt.flag = 1;
		}
		else if ( opt.launch <= get_xltime() ) {
			lr = set_dist0(lr,&u1);
			opt.launch = 0;
			opt.flag = 1;
		}
	}
	else if ( destroy_check(lr) ) {
		if ( opt.destroy == 0 ) {
			opt.destroy = get_xltime() + 
				LUMP_DESTROY_MIN + 
				(rand()%
				(LUMP_DESTROY_MAX-LUMP_DESTROY_MIN));
			opt.flag = 1;
		}
		else if ( opt.destroy <= get_xltime() ) {
			lr0 = lr;
			lr = lr->next;
			lr0->next = 0;
			free_lr(lr0);
			opt.destroy = 0;
			if ( opt.lump )
				d_f_ree(opt.lump);
			opt.lump = 0;
			opt.flag = 1;
		}
	}
	else {
		if ( opt.launch ) {
			opt.launch = 0;
			opt.flag = 1;
		}
		if ( opt.destroy ) {
			opt.destroy = 0;
			opt.flag = 1;
		}
	}

	if ( lr && lr->distance == 0 )  {
		if ( opt.lump == 0 ) {
		LUMP_INFO info;
		new:
			info.crd = ll_copy_str(get_url_str2(&u1),1387);
			opt.lump = get_lump_path(new_lump());

log_printf(LOG_DEBUG,"new lump = %s",n_string(std_cm,opt.lump));

			save_lump_info(opt.lump,&info);
/*
printf("opt.lum1 = %s\n",n_string(std_cm,opt.lump));
*/
			opt.flag = 1;
			free_lump_info(&info);
		}
		else {
			path = get_lump_info_path(opt.lump);
			fd = open(path,O_RDONLY);
			if ( fd < 0 ) {
log_printf(LOG_DEBUG,"cannot open the lump path %s",path);

				d_f_ree(opt.lump);
				d_f_ree(path);
				opt.lump = 0;
				goto new;
			}
			close(fd);
			d_f_ree(path);
		}
	}
/*
printf("9\n");
*/
	loop_ditect = check_loop_lump(&lr);

	lr = filter_lr(lr);
	if ( cmp_lr(lr,my_lr) || opt.flag || loop_ditect ) {
		opt.fade_interval = FADE_INTERVAL_MIN;
		opt.fade_time = get_xltime() + opt.fade_interval;
		save_lr(&u1,lr,&opt);
		trigger_lr(ses,a);
	}
	if ( opt.fade_time ) {
		if ( opt.fade_time <= get_xltime() ) {
			opt.fade_interval = opt.fade_interval * 2;
			if ( opt.fade_interval >= FADE_INTERVAL_MAX ) {
				opt.fade_time = 0;
				opt.fade_interval = 0;
			}
			else {
				opt.fade_time = get_xltime() 
						+ opt.fade_interval;
			}
			save_lr(&u1,lr,&opt);
		}
	}
	now = get_xltime();
	if ( opt.destroy ) {
		if ( now < opt.destroy )
			insert_tick_que(opt.destroy-get_xltime(),
				filename,TQT_LMP,TQL_LUMP);
		else	insert_tick_que(0,
				filename,TQT_LMP,TQL_LUMP);
	}
	if ( opt.launch ) {
		if ( now < opt.launch )
			insert_tick_que(opt.launch-get_xltime(),
				filename,TQT_LMP,TQL_LUMP);
		else	insert_tick_que(0,
				filename,TQT_LMP,TQL_LUMP);
	}
	if ( opt.fade_time ) {
		insert_tick_que(opt.fade_interval,filename,TQT_LMP,
					TQL_LUMP);
	}
	free_url(&u1);
	free_lr(lr);
	free_around_list2(a);
	free_lump_opt(&opt);
/*
printf("10\n");
*/
}


int
tick_lump(TICK_QUE * t,unsigned int tim)
{
int d;

	d = tim - t->invoke_time;
	if ( d > 0 ) {
		if ( d > 31 )
			d = LUMP_DELAY;
		else d = 1<<(d-1);
		if ( d > LUMP_DELAY )
			d = LUMP_DELAY;
	}
	else	d = 0;
	insert_tick_que(
		d,
		t->filename,TQT_LMP,
		TQL_LUMP);
	return 0;
}


unsigned int
_lump_trigger(int ses,URL * u,L_CHAR * db,L_CHAR * target,int interval)
{
URL u2;
L_CHAR * f;
XL_SEXP * ret;
unsigned int _ret;

set_cpu_msg(572);
	copy_url(&u2,u);
	if ( u2.db )
		d_f_ree(u2.db);
	u2.db = ll_copy_str(db,1386);
	if ( u2.resource )
		d_f_ree(u2.resource);
	u2.resource = nl_copy_str(std_cm,"db.pmd");
	f = get_url_filepath(&u2);
	gc_push(0,0,"_lump_trigger");

set_cpu_msg(573);

	ret = remote_session(
		gblisp_top_env0,
		ses,
		&u2,
		l_string(std_cm,"gbpmd"),
		l_string(std_cm,"user"),
		l_string(std_cm,"Set"),
		List(List(n_get_symbol("trigger"),
			get_string(f),
			get_string(target),
			get_integer(interval,0),
			-1),
			-1),
		0,0,0);
set_cpu_msg(574);
	if ( get_type(ret) == GBT_ERROR ) {
		print_sexp(s_stdout,ret,0);
		printf("\n");
		_ret = 0;
	}
	else if ( get_type(ret) == GBT_INTEGER ) {
		_ret = ret->integer.data;
	}
	else	_ret = 0;

	gc_pop(0,0);
	d_f_ree(f);
	free_url(&u2);
set_cpu_msg(575);
	return _ret;
}

unsigned int
lump_trigger(int ses,L_CHAR * crd,L_CHAR * target,int interval)
{
URL u1,u2;
XL_SEXP * r, * r2;
LUMP_ROUTE * lr, * lr1, * lr2;
LUMP_OPT opt2;
L_CHAR * c;
int len;
unsigned int _ret,__ret;

	_ret = 0;
	len = l_strlen(crd);
	if ( l_strcmp(&crd[len-4],l_string(std_cm,".crd")) )
		return 0;
	get_url2(&u1,crd,1246);

	r = remote_fetch_lump(ses,&u1);

	lr = get_lr(0,r,0);

	for ( lr1 = lr ; lr1 ; lr1 = lr1->next ) {
		init_lump_opt(&opt2);
		get_url2(&u2,lr1->lump_crd,1247);
		r2 = remote_fetch_lump(ses,&u2);
		lr2 = get_lr(&opt2,r2,0);
		free_lr(lr2);

		if ( opt2.lump ) {
			__ret = _lump_trigger(ses,&u2,opt2.lump,target,
					interval);
			if ( _ret < __ret )
				_ret = __ret;
		}

		free_lump_opt(&opt2);
		free_url(&u2);
	}
	free_url(&u1);
	free_lr(lr);
	return _ret;
}
